/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.junit.TestTools;
import org.onlab.junit.TestUtils;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.common.event.impl.TestEventDispatcher;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.faultmanagement.impl.AlarmManager;
import org.onosproject.faultmanagement.impl.DistributedAlarmStore;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmListener;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.store.service.TestStorageService;

public class AlarmManagerTest {
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:bar");
    private static final DefaultAlarm ALARM_A = new DefaultAlarm.Builder(DEVICE_ID, "aaa", Alarm.SeverityLevel.CRITICAL, 0L).build();
    private static final DefaultAlarm ALARM_A_WITHSRC = new DefaultAlarm.Builder((Alarm)ALARM_A).forSource(AlarmEntityId.alarmEntityId((String)"port:foo")).build();
    private static final DefaultAlarm ALARM_B = new DefaultAlarm.Builder(DEVICE_ID, "bbb", Alarm.SeverityLevel.CRITICAL, 0L).build();
    private AlarmManager manager;
    private DistributedAlarmStore alarmStore;
    protected TestListener listener = new TestListener();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.alarmStore = new DistributedAlarmStore();
        TestUtils.setField((Object)this.alarmStore, (String)"storageService", (Object)new TestStorageService());
        this.alarmStore.activate();
        this.manager = new AlarmManager();
        this.manager.addListener((EventListener)this.listener);
        NetTestTools.injectEventDispatcher((Object)this.manager, (EventDeliveryService)new TestEventDispatcher());
        this.manager.store = this.alarmStore;
        this.manager.activate();
    }

    @Test
    public void deactivate() throws Exception {
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of((Object)ALARM_B, (Object)ALARM_A));
        this.verifyGettingSetsOfAlarms(this.manager, 2, 2);
        this.alarmStore.deactivate();
        this.manager.removeListener((EventListener)this.listener);
        this.manager.deactivate();
        NetTestTools.injectEventDispatcher((Object)this.manager, null);
        TestCase.assertFalse((String)"Store should not have delegate", (boolean)this.alarmStore.hasDelegate());
    }

    @Test
    public void testGettersWhenNoAlarms() {
        Assert.assertTrue((String)"No alarms should be present", (boolean)this.manager.getAlarms().isEmpty());
        Assert.assertTrue((String)"No active alarms should be present", (boolean)this.manager.getActiveAlarms().isEmpty());
        Assert.assertTrue((String)"The map should be empty per unknown device", (boolean)this.manager.getAlarmCounts(DeviceId.NONE).keySet().isEmpty());
        Assert.assertTrue((String)"The counts should be empty", (boolean)this.manager.getAlarmCounts().keySet().isEmpty());
        Assert.assertEquals((String)"Incorrect number of alarms for unknown device", (long)0L, (long)this.manager.getAlarms(DeviceId.NONE).size());
        Assert.assertEquals((String)"Incorrect number of major alarms for unknown device", (long)0L, (long)this.manager.getAlarms(Alarm.SeverityLevel.MAJOR).size());
        this.exception.expect(NullPointerException.class);
        this.manager.getAlarm(null);
        this.exception.expect(ItemNotFoundException.class);
        this.manager.getAlarm(AlarmId.alarmId((long)1L));
    }

    @Test
    public void testAlarmUpdates() throws InterruptedException {
        Assert.assertTrue((String)"No alarms should be present", (boolean)this.manager.getAlarms().isEmpty());
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of());
        Assert.assertTrue((String)"No alarms should be present", (boolean)this.manager.getAlarms().isEmpty());
        Map<Alarm.SeverityLevel, Long> zeroAlarms = new CountsMapBuilder().create();
        Assert.assertEquals((String)"No alarms count should be present", zeroAlarms, (Object)this.manager.getAlarmCounts());
        Assert.assertEquals((String)"No alarms count should be present", zeroAlarms, (Object)this.manager.getAlarmCounts(DEVICE_ID));
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of((Object)ALARM_B, (Object)ALARM_A));
        this.verifyGettingSetsOfAlarms(this.manager, 2, 2);
        this.validateEvents(new Enum[]{AlarmEvent.Type.CREATED, AlarmEvent.Type.CREATED});
        Map<Alarm.SeverityLevel, Long> critical2 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 2L).create();
        Assert.assertEquals((String)"A critical should be present", critical2, (Object)this.manager.getAlarmCounts());
        Assert.assertEquals((String)"A critical should be present", critical2, (Object)this.manager.getAlarmCounts(DEVICE_ID));
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of((Object)ALARM_A));
        this.verifyGettingSetsOfAlarms(this.manager, 2, 1);
        this.validateEvents(new Enum[]{AlarmEvent.Type.CREATED});
        Map<Alarm.SeverityLevel, Long> critical1cleared1 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 1L).with(Alarm.SeverityLevel.CLEARED, 1L).create();
        Assert.assertEquals((String)"A critical should be present and cleared", critical1cleared1, (Object)this.manager.getAlarmCounts());
        Assert.assertEquals((String)"A critical should be present and cleared", critical1cleared1, (Object)this.manager.getAlarmCounts(DEVICE_ID));
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of((Object)ALARM_A));
        this.verifyGettingSetsOfAlarms(this.manager, 2, 1);
        this.validateEvents(new Enum[0]);
        Assert.assertEquals((String)"Map should not be changed for same alarm", critical1cleared1, (Object)this.manager.getAlarmCounts());
        Assert.assertEquals((String)"Map should not be changed for same alarm", critical1cleared1, (Object)this.manager.getAlarmCounts(DEVICE_ID));
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of((Object)ALARM_A, (Object)ALARM_A_WITHSRC));
        this.verifyGettingSetsOfAlarms(this.manager, 3, 2);
        this.validateEvents(new Enum[]{AlarmEvent.Type.CREATED});
        Map<Alarm.SeverityLevel, Long> critical2cleared1 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 2L).with(Alarm.SeverityLevel.CLEARED, 1L).create();
        Assert.assertEquals((String)"A critical should be present", critical2cleared1, (Object)this.manager.getAlarmCounts());
        Assert.assertEquals((String)"A critical should be present", critical2cleared1, (Object)this.manager.getAlarmCounts(DEVICE_ID));
        this.manager.updateAlarms(DEVICE_ID, (Set)ImmutableSet.of());
        this.verifyGettingSetsOfAlarms(this.manager, 3, 0);
        this.validateEvents(new Enum[]{AlarmEvent.Type.CREATED, AlarmEvent.Type.CREATED});
        Assert.assertEquals(new CountsMapBuilder().with(Alarm.SeverityLevel.CLEARED, 3L).create(), (Object)this.manager.getAlarmCounts(DEVICE_ID));
        Assert.assertEquals((String)"The counts should be empty for unknown devices", zeroAlarms, (Object)this.manager.getAlarmCounts(DeviceId.NONE));
        Assert.assertEquals((String)"The counts should be empty for unknown devices", zeroAlarms, (Object)this.manager.getAlarmCounts(DeviceId.deviceId((String)"junk:junk")));
    }

    private void verifyGettingSetsOfAlarms(AlarmManager am, int expectedTotal, int expectedActive) {
        Assert.assertEquals((String)"Incorrect total alarms", (long)expectedTotal, (long)am.getAlarms().size());
        Assert.assertEquals((String)"Incorrect active alarms count", (long)expectedActive, (long)am.getActiveAlarms().size());
    }

    private void validateEvents(Enum ... types) {
        TestTools.assertAfter((int)100, () -> {
            int i = 0;
            Assert.assertEquals((String)"wrong events received", (long)types.length, (long)this.listener.events.size());
            for (Event event : this.listener.events) {
                Assert.assertEquals((String)"incorrect event type", (Object)types[i], (Object)event.type());
                ++i;
            }
            this.listener.events.clear();
        });
    }

    private static class TestListener
    implements AlarmListener {
        protected List<AlarmEvent> events = Lists.newArrayList();

        private TestListener() {
        }

        public void event(AlarmEvent event) {
            this.events.add(event);
        }
    }

    private static class CountsMapBuilder {
        private final Map<Alarm.SeverityLevel, Long> map = new HashMap<Alarm.SeverityLevel, Long>();

        private CountsMapBuilder() {
        }

        public CountsMapBuilder with(Alarm.SeverityLevel sev, Long count) {
            this.map.put(sev, count);
            return this;
        }

        public Map<Alarm.SeverityLevel, Long> create() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

