/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.faultmanagement.api.AlarmStoreDelegate;
import org.onosproject.faultmanagement.impl.DistributedAlarmStore;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.service.TestStorageService;

public class DistributedAlarmStoreTest {
    private DistributedAlarmStore alarmStore;
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:bar");
    private static final DefaultAlarm ALARM_A = new DefaultAlarm.Builder(DEVICE_ID, "aaa", Alarm.SeverityLevel.CRITICAL, 0L).build();

    @Before
    public void setUp() {
        this.alarmStore = new DistributedAlarmStore();
        this.alarmStore.storageService = new TestStorageService();
        this.alarmStore.setDelegate((StoreDelegate)((AlarmStoreDelegate)event -> {}));
        this.alarmStore.activate();
    }

    @After
    public void tearDown() {
        this.alarmStore.deactivate();
    }

    @Test
    public void basics() {
        this.alarmStore.setAlarm((Alarm)ALARM_A);
        Assert.assertTrue((String)"There should be one alarm in the set.", (boolean)this.alarmStore.getAlarms().contains(ALARM_A));
        Assert.assertTrue((String)"The same alarm should be returned.", (boolean)this.alarmStore.getAlarms(DEVICE_ID).contains(ALARM_A));
        Assert.assertTrue((String)"The alarm should be the same", (boolean)this.alarmStore.getAlarm(ALARM_A.id()).equals(ALARM_A));
        this.alarmStore.removeAlarm(ALARM_A.id());
        Assert.assertFalse((String)"There should be no alarm in the set.", (boolean)this.alarmStore.getAlarms().contains(ALARM_A));
    }
}

