/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.ChassisId;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.faultmanagement.impl.PollingAlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderRegistry;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderRegistryAdapter;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderService;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdapter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.osgi.service.component.ComponentContext;

public class PollingAlarmProviderTest {
    private final DeviceService deviceService = new MockDeviceService();
    private final MastershipService mastershipService = new MockMastershipService();
    private final AlarmProviderRegistry providerRegistry = new MockDeviceProviderRegistry();
    private final AlarmProviderService alarmProviderService = new MockAlarmProviderService();
    private final ComponentContext context = new MockComponentContext();
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:1.1.1.1:1");
    private Device device = new MockDevice(ProviderId.NONE, DEVICE_ID, Device.Type.OTHER, "foo.inc", "0", "0", "0", null, new Annotations[]{DefaultAnnotations.builder().build()});
    private final NodeId nodeId = NodeId.nodeId((String)"fooNode");
    private final MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, DEVICE_ID, new RoleInfo(this.nodeId, (List)ImmutableList.of()));
    private final DeviceEvent deviceEvent = new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, this.device);
    private static final DefaultAlarm ALARM = new DefaultAlarm.Builder(DEVICE_ID, "aaa", Alarm.SeverityLevel.CRITICAL, 0L).build();
    private final Driver driver = new MockDriver();
    private PollingAlarmProvider provider = new PollingAlarmProvider();
    private Set<DeviceListener> deviceListeners = new HashSet<DeviceListener>();
    private Set<MastershipListener> mastershipListeners = new HashSet<MastershipListener>();
    private HashMap<DeviceId, Collection<Alarm>> alarmStore = new HashMap();

    @Before
    public void setUp() {
        this.provider.providerRegistry = this.providerRegistry;
        this.provider.deviceService = this.deviceService;
        this.provider.mastershipService = this.mastershipService;
        AbstractProjectableModel.setDriverService(null, (DriverService)new DriverServiceAdapter());
        this.provider.activate(this.context);
    }

    @Test
    public void activate() throws Exception {
        Assert.assertFalse((String)"Provider should be registered", (boolean)this.providerRegistry.getProviders().contains(this.provider));
        Assert.assertEquals((String)"Device listener should be added", (long)1L, (long)this.deviceListeners.size());
        Assert.assertEquals((String)"Incorrect alarm provider service", (Object)this.alarmProviderService, (Object)this.provider.providerService);
        Assert.assertEquals((String)"Mastership listener should be added", (long)1L, (long)this.mastershipListeners.size());
        Assert.assertEquals((String)"Incorrect polling frequency", (long)1L, (long)this.provider.alarmPollFrequencySeconds);
        Assert.assertFalse((String)"Executor should be running", (boolean)this.provider.alarmsExecutor.isShutdown());
        this.provider.activate(null);
        Assert.assertEquals((String)"Incorrect polling frequency, should be default", (long)60L, (long)this.provider.alarmPollFrequencySeconds);
    }

    @Test
    public void deactivate() throws Exception {
        this.provider.deactivate();
        Assert.assertEquals((String)"Device listener should be removed", (long)0L, (long)this.deviceListeners.size());
        Assert.assertEquals((String)"Mastership listener should be removed", (long)0L, (long)this.mastershipListeners.size());
        Assert.assertFalse((String)"Provider should not be registered", (boolean)this.providerRegistry.getProviders().contains(this.provider));
        Assert.assertTrue((boolean)this.provider.alarmsExecutor.isShutdown());
        Assert.assertNull((Object)this.provider.providerService);
    }

    @Test
    public void modified() throws Exception {
        this.provider.modified(null);
        Assert.assertEquals((String)"Incorrect polling frequency", (long)1L, (long)this.provider.alarmPollFrequencySeconds);
        this.provider.activate(null);
        this.provider.modified(this.context);
        Assert.assertEquals((String)"Incorrect polling frequency", (long)1L, (long)this.provider.alarmPollFrequencySeconds);
    }

    @Test
    public void alarmsPresent() throws IOException {
        TestTools.assertAfter((int)1100, () -> {
            Assert.assertTrue((String)"Alarms should be added", (boolean)this.alarmStore.containsKey(DEVICE_ID));
            Assert.assertTrue((String)"Alarms should be added", (boolean)this.alarmStore.get(DEVICE_ID).contains(ALARM));
        });
    }

    @Test
    public void mastershipListenerEvent() throws Exception {
        Assert.assertTrue((String)"Incorrect relevant event", (boolean)this.provider.mastershipListener.isRelevant((Event)this.mastershipEvent));
        this.provider.mastershipListener.event((Event)this.mastershipEvent);
        TestTools.assertAfter((int)1100, () -> Assert.assertTrue((String)"Alarms should be added", (boolean)this.alarmStore.containsKey(DEVICE_ID)));
    }

    @Test
    public void deviceListenerEvent() throws Exception {
        Assert.assertTrue((String)"Incorrect relevant event", (boolean)this.provider.deviceListener.isRelevant((Event)this.deviceEvent));
        this.provider.deviceListener.event((Event)this.deviceEvent);
        TestTools.assertAfter((int)1100, () -> Assert.assertTrue((String)"Alarms should be added", (boolean)this.alarmStore.containsKey(DEVICE_ID)));
    }

    private class TestAlarmConsumer
    extends AbstractHandlerBehaviour
    implements AlarmConsumer {
        private TestAlarmConsumer() {
        }

        public List<Alarm> consumeAlarms() {
            return ImmutableList.of((Object)ALARM);
        }
    }

    private class MockDriver
    extends DriverAdapter {
        private MockDriver() {
        }

        public <T extends Behaviour> T createBehaviour(DriverHandler handler, Class<T> behaviourClass) {
            return (T)((Object)new TestAlarmConsumer());
        }
    }

    private class MockDevice
    extends DefaultDevice {
        public MockDevice(ProviderId providerId, DeviceId id, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassisId, Annotations ... annotations) {
            super(providerId, id, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, annotations);
        }

        protected Driver locateDriver() {
            return PollingAlarmProviderTest.this.driver;
        }

        public Driver driver() {
            return PollingAlarmProviderTest.this.driver;
        }
    }

    private class MockDictionary
    extends Dictionary {
        private MockDictionary() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Enumeration keys() {
            return null;
        }

        public Enumeration elements() {
            return null;
        }

        public Object get(Object key) {
            if (key.equals("pollFrequency")) {
                return "1";
            }
            return null;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Object remove(Object key) {
            return null;
        }
    }

    private class MockComponentContext
    extends ComponentContextAdapter {
        private MockComponentContext() {
        }

        public Dictionary getProperties() {
            return new MockDictionary();
        }
    }

    private class MockAlarmProviderService
    implements AlarmProviderService {
        private MockAlarmProviderService() {
        }

        public void updateAlarmList(DeviceId deviceId, Collection<Alarm> alarms) {
            if (PollingAlarmProviderTest.this.alarmStore.containsKey(deviceId)) {
                Collection deviceAlarms = (Collection)PollingAlarmProviderTest.this.alarmStore.get(deviceId);
                deviceAlarms.addAll(alarms);
                PollingAlarmProviderTest.this.alarmStore.put(deviceId, deviceAlarms);
            } else {
                PollingAlarmProviderTest.this.alarmStore.put(deviceId, alarms);
            }
        }

        public AlarmProvider provider() {
            return null;
        }
    }

    private class MockDeviceProviderRegistry
    extends AlarmProviderRegistryAdapter {
        Set<ProviderId> providers = new HashSet<ProviderId>();

        private MockDeviceProviderRegistry() {
        }

        public AlarmProviderService register(AlarmProvider provider) {
            return PollingAlarmProviderTest.this.alarmProviderService;
        }

        public void unregister(AlarmProvider provider) {
            this.providers.remove(provider.id());
        }

        public Set<ProviderId> getProviders() {
            return this.providers;
        }
    }

    private class MockMastershipService
    extends MastershipServiceAdapter {
        private MockMastershipService() {
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return true;
        }

        public void addListener(MastershipListener listener) {
            PollingAlarmProviderTest.this.mastershipListeners.add(listener);
        }

        public void removeListener(MastershipListener listener) {
            PollingAlarmProviderTest.this.mastershipListeners.remove(listener);
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Device getDevice(DeviceId did) {
            if (did.equals((Object)DEVICE_ID)) {
                return PollingAlarmProviderTest.this.device;
            }
            return null;
        }

        public Iterable<Device> getAvailableDevices() {
            return ImmutableSet.of((Object)PollingAlarmProviderTest.this.device);
        }

        public boolean isAvailable(DeviceId did) {
            return did.equals((Object)DEVICE_ID);
        }

        public void addListener(DeviceListener listener) {
            PollingAlarmProviderTest.this.deviceListeners.add(listener);
        }

        public void removeListener(DeviceListener listener) {
            PollingAlarmProviderTest.this.deviceListeners.remove(listener);
        }
    }
}

