/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.faultmanagement.web.AlarmCodecContext;
import org.onosproject.faultmanagement.web.AlarmJsonMatcher;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;

public class AlarmCodecTest {
    private final AlarmCodecContext context = new AlarmCodecContext();
    private final Alarm alarmMinimumFields = new DefaultAlarm.Builder(new AlarmId(44L), DeviceId.deviceId((String)"of:2222000000000000"), "NE unreachable", Alarm.SeverityLevel.CLEARED, 1L).build();
    private final Alarm alarmWithSource = new DefaultAlarm.Builder(new AlarmId(44L), DeviceId.deviceId((String)"of:2222000000000000"), "NE unreachable", Alarm.SeverityLevel.CLEARED, 1L).forSource(AlarmEntityId.alarmEntityId((String)"port:1/2/3/4")).withTimeUpdated(2L).withTimeCleared(Long.valueOf(3L)).withServiceAffecting(true).withAcknowledged(true).withManuallyClearable(true).withAssignedUser("the assigned user").build();

    @Test
    public void alarmCodecTestWithOptionalFieldMissing() {
        JsonCodec<Alarm> codec = this.context.codec(Alarm.class);
        MatcherAssert.assertThat(codec, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ObjectNode alarmJson = codec.encode((Object)this.alarmMinimumFields, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)alarmJson, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)alarmJson, (Matcher)AlarmJsonMatcher.matchesAlarm(this.alarmMinimumFields));
    }

    @Test
    public void alarmCodecTestWithOptionalField() {
        JsonCodec<Alarm> codec = this.context.codec(Alarm.class);
        MatcherAssert.assertThat(codec, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ObjectNode alarmJson = codec.encode((Object)this.alarmWithSource, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)alarmJson, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)alarmJson, (Matcher)AlarmJsonMatcher.matchesAlarm(this.alarmWithSource));
    }

    @Test
    public void verifyMinimalAlarmIsEncoded() throws Exception {
        JsonCodec<Alarm> alarmCodec = this.context.codec(Alarm.class);
        Alarm alarm = this.getDecodedAlarm(alarmCodec, "alarm-minimal.json");
        this.assertCommon(alarm);
        MatcherAssert.assertThat((Object)alarm.timeCleared(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)alarm.assignedUser(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void verifyFullyLoadedAlarmIsEncoded() throws Exception {
        JsonCodec<Alarm> alarmCodec = this.context.codec(Alarm.class);
        Alarm alarm = this.getDecodedAlarm(alarmCodec, "alarm-full.json");
        this.assertCommon(alarm);
        MatcherAssert.assertThat((Object)alarm.timeCleared(), (Matcher)Matchers.is((Object)2222L));
        MatcherAssert.assertThat((Object)alarm.assignedUser(), (Matcher)Matchers.is((Object)"foo"));
    }

    private void assertCommon(Alarm alarm) {
        MatcherAssert.assertThat((Object)alarm.id(), (Matcher)Matchers.is((Object)new AlarmId(10L)));
        MatcherAssert.assertThat((Object)alarm.description(), (Matcher)Matchers.is((Object)"NE is not reachable"));
        MatcherAssert.assertThat((Object)alarm.source(), (Matcher)Matchers.is((Object)AlarmEntityId.NONE));
        MatcherAssert.assertThat((Object)alarm.timeRaised(), (Matcher)Matchers.is((Object)999L));
        MatcherAssert.assertThat((Object)alarm.timeUpdated(), (Matcher)Matchers.is((Object)1111L));
        MatcherAssert.assertThat((Object)alarm.severity(), (Matcher)Matchers.is((Object)Alarm.SeverityLevel.MAJOR));
        MatcherAssert.assertThat((Object)alarm.serviceAffecting(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)alarm.acknowledged(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)alarm.manuallyClearable(), (Matcher)Matchers.is((Object)true));
    }

    private Alarm getDecodedAlarm(JsonCodec<Alarm> codec, String resourceName) throws IOException {
        InputStream jsonStream = AlarmCodecTest.class.getResourceAsStream(resourceName);
        JsonNode json = this.context.mapper().readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        Alarm result = (Alarm)codec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        return result;
    }
}

