/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlarmCodec
extends JsonCodec<Alarm> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ObjectNode encode(Alarm alarm, CodecContext context) {
        Preconditions.checkNotNull((Object)alarm, (Object)"Alarm cannot be null");
        return context.mapper().createObjectNode().put("id", alarm.id().fingerprint()).put("deviceId", alarm.deviceId().toString()).put("description", alarm.description()).put("source", alarm.source() == null ? null : alarm.source().toString()).put("timeRaised", alarm.timeRaised()).put("timeUpdated", alarm.timeUpdated()).put("timeCleared", alarm.timeCleared()).put("severity", alarm.severity().toString()).put("serviceAffecting", alarm.serviceAffecting()).put("acknowledged", alarm.acknowledged()).put("manuallyClearable", alarm.manuallyClearable()).put("assignedUser", alarm.assignedUser());
    }

    public Alarm decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("id={}, full json={} ", (Object)json.get("id"), (Object)json);
        Long id = json.get("id").asLong();
        DeviceId deviceId = DeviceId.deviceId((String)json.get("deviceId").asText());
        String description = json.get("description").asText();
        Long timeRaised = json.get("timeRaised").asLong();
        Long timeUpdated = json.get("timeUpdated").asLong();
        JsonNode jsonTimeCleared = json.get("timeCleared");
        Long timeCleared = jsonTimeCleared == null || jsonTimeCleared.isNull() ? null : Long.valueOf(jsonTimeCleared.asLong());
        Alarm.SeverityLevel severity = Alarm.SeverityLevel.valueOf((String)json.get("severity").asText().toUpperCase());
        Boolean serviceAffecting = json.get("serviceAffecting").asBoolean();
        Boolean acknowledged = json.get("acknowledged").asBoolean();
        Boolean manuallyClearable = json.get("manuallyClearable").asBoolean();
        JsonNode jsonAssignedUser = json.get("assignedUser");
        String assignedUser = jsonAssignedUser == null || jsonAssignedUser.isNull() ? null : jsonAssignedUser.asText();
        return new DefaultAlarm.Builder(AlarmId.valueOf((long)id), deviceId, description, severity, timeRaised.longValue()).forSource(AlarmEntityId.NONE).withTimeUpdated(timeUpdated.longValue()).withTimeCleared(timeCleared).withServiceAffecting(serviceAffecting.booleanValue()).withAcknowledged(acknowledged.booleanValue()).withManuallyClearable(manuallyClearable.booleanValue()).withAssignedUser(assignedUser).build();
    }
}

