/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.faultmanagement.web.AlarmCodec;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="alarms")
public class AlarmsWebResource
extends AbstractWebResource {
    public static final String ALARM_NOT_FOUND = "Alarm is not found";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @GET
    @Produces(value={"application/json"})
    public Response getAlarms(@DefaultValue(value="false") @QueryParam(value="includeCleared") boolean includeCleared) {
        this.log.info("Requesting all alarms, includeCleared={}", (Object)includeCleared);
        AlarmService service = (AlarmService)this.get(AlarmService.class);
        Set alarms = includeCleared ? service.getAlarms() : service.getActiveAlarms();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("alarms", (JsonNode)this.codec(Alarm.class).encode((Iterable)alarms, (CodecContext)this));
        return AlarmsWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getAlarm(@PathParam(value="id") String id) {
        this.log.info("HTTP GET alarm for id={}", (Object)id);
        AlarmId alarmId = AlarmsWebResource.toAlarmId((String)id);
        Alarm alarm = ((AlarmService)this.get(AlarmService.class)).getAlarm(alarmId);
        ObjectNode result = this.mapper().createObjectNode();
        result.set("alarm", (JsonNode)this.codec(Alarm.class).encode((Object)alarm, (CodecContext)this));
        return AlarmsWebResource.ok((Object)result.toString()).build();
    }

    @PUT
    @Path(value="{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="alarm_id") String alarmIdPath, InputStream stream) {
        this.log.info("PUT NEW ALARM at /{}", (Object)alarmIdPath);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            this.log.info("jsonTree={}", (Object)jsonTree);
            Alarm alarm = (Alarm)this.codec(Alarm.class).decode(jsonTree, (CodecContext)this);
            AlarmService service = (AlarmService)this.get(AlarmService.class);
            if (Long.parseLong(alarmIdPath) != alarm.id().fingerprint()) {
                throw new IllegalArgumentException("id in path is " + Long.parseLong(alarmIdPath) + " but payload uses id=" + alarm.id().fingerprint());
            }
            Alarm updated = service.update(alarm);
            ObjectNode encoded = new AlarmCodec().encode(updated, (CodecContext)this);
            return AlarmsWebResource.ok((Object)encoded.toString()).build();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private static AlarmId toAlarmId(String id) {
        try {
            return AlarmId.valueOf((long)Long.parseLong(id));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Alarm id should be numeric", ex);
        }
    }
}

