/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import com.fasterxml.jackson.databind.JsonNode;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;

public final class AlarmJsonMatcher
extends TypeSafeDiagnosingMatcher<JsonNode> {
    private final Alarm alarm;

    private AlarmJsonMatcher(Alarm alarm) {
        this.alarm = alarm;
    }

    public boolean matchesSafely(JsonNode jsonAlarm, Description description) {
        String alarmDesc;
        String alarmDeviceId;
        String alarmId;
        String jsonAlarmId = jsonAlarm.get("id").asText();
        if (!jsonAlarmId.equals(alarmId = Long.toString(this.alarm.id().fingerprint()))) {
            description.appendText("alarm id was " + jsonAlarmId);
            return false;
        }
        String jsonDeviceId = jsonAlarm.get("deviceId").asText();
        if (!jsonDeviceId.equals(alarmDeviceId = this.alarm.deviceId().toString())) {
            description.appendText("DeviceId was " + jsonDeviceId);
            return false;
        }
        String jsonDescription = jsonAlarm.get("description").asText();
        if (!jsonDescription.equals(alarmDesc = this.alarm.description())) {
            description.appendText("description was " + jsonDescription);
            return false;
        }
        long jsonTimeRaised = jsonAlarm.get("timeRaised").asLong();
        long timeRaised = this.alarm.timeRaised();
        if (timeRaised != jsonTimeRaised) {
            description.appendText("timeRaised was " + jsonTimeRaised);
            return false;
        }
        long jsonTimeUpdated = jsonAlarm.get("timeUpdated").asLong();
        long timeUpdated = this.alarm.timeUpdated();
        if (timeUpdated != jsonTimeUpdated) {
            description.appendText("timeUpdated was " + jsonTimeUpdated);
            return false;
        }
        JsonNode jsonTimeClearedNode = jsonAlarm.get("timeCleared");
        if (this.alarm.timeCleared() != null) {
            Long jsonTimeCleared = jsonTimeClearedNode.longValue();
            Long timeCleared = this.alarm.timeCleared();
            if (!timeCleared.equals(jsonTimeCleared)) {
                description.appendText("Time Cleared was " + jsonTimeCleared);
                return false;
            }
        } else if (!jsonTimeClearedNode.isNull()) {
            description.appendText("Time Cleared should be null");
            return false;
        }
        String jsonSeverity = jsonAlarm.get("severity").asText();
        String severity = this.alarm.severity().toString();
        if (!severity.equals(jsonSeverity)) {
            description.appendText("severity was " + jsonSeverity);
            return false;
        }
        JsonNode jsonAlarmNode = jsonAlarm.get("source");
        if (this.alarm.source() != null) {
            String jsonSource = jsonAlarmNode.textValue();
            String source = this.alarm.source().toString();
            if (!source.equals(jsonSource)) {
                description.appendText("source was " + jsonSource);
                return false;
            }
        } else if (!jsonAlarmNode.isNull()) {
            description.appendText("source should be null");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.alarm.toString());
    }

    public static AlarmJsonMatcher matchesAlarm(Alarm alarm) {
        return new AlarmJsonMatcher(alarm);
    }
}

