/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fwd;

import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ReactiveForwarding {
    private static final int TIMEOUT = 10;
    private static final int PRIORITY = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private ApplicationId appId;
    @Property(name="packetOutOnly", boolValue={false}, label="Enable packet-out only forwarding; default is false")
    private boolean packetOutOnly = false;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.fwd");
        this.packetService.addProcessor((PacketProcessor)this.processor, 0x2AAAAAAC);
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean enabled;
        Dictionary properties = context.getProperties();
        String flag = (String)properties.get("packetOutOnly");
        if (flag != null && this.packetOutOnly != (enabled = flag.equals("true"))) {
            this.packetOutOnly = enabled;
            this.log.info("Reconfigured. Packet-out only forwarding is {}", (Object)(this.packetOutOnly ? "enabled" : "disabled"));
        }
    }

    private boolean isControlPacket(Ethernet eth) {
        short type = eth.getEtherType();
        return type == -30516 || type == -30398;
    }

    private boolean isIpv6Multicast(Ethernet eth) {
        return eth.getEtherType() == -31011 && eth.isMulticast();
    }

    private Path pickForwardPath(Set<Path> paths, PortNumber notToPort) {
        for (Path path : paths) {
            if (path.src().port().equals((Object)notToPort)) continue;
            return path;
        }
        return null;
    }

    private void flood(PacketContext context) {
        if (this.topologyService.isBroadcastPoint(this.topologyService.currentTopology(), context.inPacket().receivedFrom())) {
            this.packetOut(context, PortNumber.FLOOD);
        } else {
            context.block();
        }
    }

    private void packetOut(PacketContext context, PortNumber portNumber) {
        context.treatmentBuilder().setOutput(portNumber);
        context.send();
    }

    private void installRule(PacketContext context, PortNumber portNumber) {
        this.packetOut(context, portNumber);
        if (!this.packetOutOnly) {
            Ethernet inPkt = context.inPacket().parsed();
            TrafficSelector.Builder builder = DefaultTrafficSelector.builder();
            builder.matchEthType(inPkt.getEtherType()).matchEthSrc(inPkt.getSourceMAC()).matchEthDst(inPkt.getDestinationMAC()).matchInport(context.inPacket().receivedFrom().port());
            TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
            treat.setOutput(portNumber);
            DefaultFlowRule f = new DefaultFlowRule(context.inPacket().receivedFrom().deviceId(), builder.build(), treat.build(), 10, this.appId, 10, false);
            this.flowRuleService.applyFlowRules(new FlowRule[]{f});
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ReactiveForwarding.this.isControlPacket(ethPkt) || ReactiveForwarding.this.isIpv6Multicast(ethPkt)) {
                return;
            }
            HostId id = HostId.hostId((MacAddress)ethPkt.getDestinationMAC());
            if (id.mac().isLinkLocal()) {
                return;
            }
            Host dst = ReactiveForwarding.this.hostService.getHost(id);
            if (dst == null) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            if (pkt.receivedFrom().deviceId().equals((Object)dst.location().deviceId())) {
                if (!context.inPacket().receivedFrom().port().equals((Object)dst.location().port())) {
                    ReactiveForwarding.this.installRule(context, dst.location().port());
                }
                return;
            }
            Set paths = ReactiveForwarding.this.topologyService.getPaths(ReactiveForwarding.this.topologyService.currentTopology(), pkt.receivedFrom().deviceId(), dst.location().deviceId());
            if (paths.isEmpty()) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            Path path = ReactiveForwarding.this.pickForwardPath(paths, pkt.receivedFrom().port());
            if (path == null) {
                ReactiveForwarding.this.log.warn("Doh... don't know where to go... {} -> {} received on {}", new Object[]{ethPkt.getSourceMAC(), ethPkt.getDestinationMAC(), pkt.receivedFrom()});
                ReactiveForwarding.this.flood(context);
                return;
            }
            ReactiveForwarding.this.installRule(context, path.src().port());
        }
    }
}

