/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fwd;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ReactiveForwarding {
    private static final int DEFAULT_TIMEOUT = 10;
    private static final int DEFAULT_PRIORITY = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private ApplicationId appId;
    @Property(name="packetOutOnly", boolValue={false}, label="Enable packet-out only forwarding; default is false")
    private boolean packetOutOnly = false;
    @Property(name="packetOutOfppTable", boolValue={false}, label="Enable first packet forwarding using OFPP_TABLE port instead of PacketOut with actual port; default is false")
    private boolean packetOutOfppTable = false;
    @Property(name="flowTimeout", intValue={10}, label="Configure Flow Timeout for installed flow rules; default is 10 sec")
    private int flowTimeout = 10;
    @Property(name="flowPriority", intValue={10}, label="Configure Flow Priority for installed flow rules; default is 10")
    private int flowPriority = 10;
    @Property(name="ipv6Forwarding", boolValue={false}, label="Enable IPv6 forwarding; default is false")
    private boolean ipv6Forwarding = false;
    @Property(name="matchDstMacOnly", boolValue={false}, label="Enable matching Dst Mac Only; default is false")
    private boolean matchDstMacOnly = false;
    @Property(name="matchVlanId", boolValue={false}, label="Enable matching Vlan ID; default is false")
    private boolean matchVlanId = false;
    @Property(name="matchIpv4Address", boolValue={false}, label="Enable matching IPv4 Addresses; default is false")
    private boolean matchIpv4Address = false;
    @Property(name="matchIpv4Dscp", boolValue={false}, label="Enable matching IPv4 DSCP and ECN; default is false")
    private boolean matchIpv4Dscp = false;
    @Property(name="matchIpv6Address", boolValue={false}, label="Enable matching IPv6 Addresses; default is false")
    private boolean matchIpv6Address = false;
    @Property(name="matchIpv6FlowLabel", boolValue={false}, label="Enable matching IPv6 FlowLabel; default is false")
    private boolean matchIpv6FlowLabel = false;
    @Property(name="matchTcpUdpPorts", boolValue={false}, label="Enable matching TCP/UDP ports; default is false")
    private boolean matchTcpUdpPorts = false;
    @Property(name="matchIcmpFields", boolValue={false}, label="Enable matching ICMPv4 and ICMPv6 fields; default is false")
    private boolean matchIcmpFields = false;

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.fwd");
        this.packetService.addProcessor((PacketProcessor)this.processor, 0x2AAAAAAC);
        this.readComponentConfiguration(context);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType((short)2048);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType((short)2054);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        if (this.ipv6Forwarding) {
            selector.matchEthType((short)-31011);
            this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        }
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Integer flowTimeoutConfigured;
        boolean matchIcmpFieldsEnabled;
        boolean matchTcpUdpPortsEnabled;
        boolean matchIpv6FlowLabelEnabled;
        boolean matchIpv6AddressEnabled;
        boolean matchIpv4DscpEnabled;
        boolean matchIpv4AddressEnabled;
        boolean matchVlanIdEnabled;
        boolean matchDstMacOnlyEnabled;
        boolean ipv6ForwardingEnabled;
        boolean packetOutOfppTableEnabled;
        Dictionary properties = context.getProperties();
        boolean packetOutOnlyEnabled = ReactiveForwarding.isPropertyEnabled(properties, "packetOutOnly");
        if (this.packetOutOnly != packetOutOnlyEnabled) {
            this.packetOutOnly = packetOutOnlyEnabled;
            this.log.info("Configured. Packet-out only forwarding is {}", (Object)(this.packetOutOnly ? "enabled" : "disabled"));
        }
        if (this.packetOutOfppTable != (packetOutOfppTableEnabled = ReactiveForwarding.isPropertyEnabled(properties, "packetOutOfppTable"))) {
            this.packetOutOfppTable = packetOutOfppTableEnabled;
            this.log.info("Configured. Forwarding using OFPP_TABLE port is {}", (Object)(this.packetOutOfppTable ? "enabled" : "disabled"));
        }
        if (this.ipv6Forwarding != (ipv6ForwardingEnabled = ReactiveForwarding.isPropertyEnabled(properties, "ipv6Forwarding"))) {
            this.ipv6Forwarding = ipv6ForwardingEnabled;
            this.log.info("Configured. IPv6 forwarding is {}", (Object)(this.ipv6Forwarding ? "enabled" : "disabled"));
        }
        if (this.matchDstMacOnly != (matchDstMacOnlyEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchDstMacOnly"))) {
            this.matchDstMacOnly = matchDstMacOnlyEnabled;
            this.log.info("Configured. Match Dst MAC Only is {}", (Object)(this.matchDstMacOnly ? "enabled" : "disabled"));
        }
        if (this.matchVlanId != (matchVlanIdEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchVlanId"))) {
            this.matchVlanId = matchVlanIdEnabled;
            this.log.info("Configured. Matching Vlan ID is {}", (Object)(this.matchVlanId ? "enabled" : "disabled"));
        }
        if (this.matchIpv4Address != (matchIpv4AddressEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchIpv4Address"))) {
            this.matchIpv4Address = matchIpv4AddressEnabled;
            this.log.info("Configured. Matching IPv4 Addresses is {}", (Object)(this.matchIpv4Address ? "enabled" : "disabled"));
        }
        if (this.matchIpv4Dscp != (matchIpv4DscpEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchIpv4Dscp"))) {
            this.matchIpv4Dscp = matchIpv4DscpEnabled;
            this.log.info("Configured. Matching IPv4 DSCP and ECN is {}", (Object)(this.matchIpv4Dscp ? "enabled" : "disabled"));
        }
        if (this.matchIpv6Address != (matchIpv6AddressEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchIpv6Address"))) {
            this.matchIpv6Address = matchIpv6AddressEnabled;
            this.log.info("Configured. Matching IPv6 Addresses is {}", (Object)(this.matchIpv6Address ? "enabled" : "disabled"));
        }
        if (this.matchIpv6FlowLabel != (matchIpv6FlowLabelEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchIpv6FlowLabel"))) {
            this.matchIpv6FlowLabel = matchIpv6FlowLabelEnabled;
            this.log.info("Configured. Matching IPv6 FlowLabel is {}", (Object)(this.matchIpv6FlowLabel ? "enabled" : "disabled"));
        }
        if (this.matchTcpUdpPorts != (matchTcpUdpPortsEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchTcpUdpPorts"))) {
            this.matchTcpUdpPorts = matchTcpUdpPortsEnabled;
            this.log.info("Configured. Matching TCP/UDP fields is {}", (Object)(this.matchTcpUdpPorts ? "enabled" : "disabled"));
        }
        if (this.matchIcmpFields != (matchIcmpFieldsEnabled = ReactiveForwarding.isPropertyEnabled(properties, "matchIcmpFields"))) {
            this.matchIcmpFields = matchIcmpFieldsEnabled;
            this.log.info("Configured. Matching ICMP (v4 and v6) fields is {}", (Object)(this.matchIcmpFields ? "enabled" : "disabled"));
        }
        if ((flowTimeoutConfigured = ReactiveForwarding.getIntegerProperty(properties, "flowTimeout")) == null) {
            this.log.info("Flow Timeout is not configured, default value is {}", (Object)this.flowTimeout);
        } else {
            this.flowTimeout = flowTimeoutConfigured;
            this.log.info("Configured. Flow Timeout is configured to {}", (Object)this.flowTimeout, (Object)" seconds");
        }
        Integer flowPriorityConfigured = ReactiveForwarding.getIntegerProperty(properties, "flowPriority");
        if (flowPriorityConfigured == null) {
            this.log.info("Flow Priority is not configured, default value is {}", (Object)this.flowPriority);
        } else {
            this.flowPriority = flowPriorityConfigured;
            this.log.info("Configured. Flow Priority is configured to {}", (Object)this.flowPriority);
        }
    }

    private static Integer getIntegerProperty(Dictionary<?, ?> properties, String propertyName) {
        Integer value = null;
        try {
            String s = (String)properties.get(propertyName);
            value = Strings.isNullOrEmpty((String)s) ? value : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            value = null;
        }
        return value;
    }

    private static boolean isPropertyEnabled(Dictionary<?, ?> properties, String propertyName) {
        boolean enabled = false;
        try {
            String flag = (String)properties.get(propertyName);
            if (flag != null) {
                enabled = flag.trim().equals("true");
            }
        }
        catch (ClassCastException e) {
            enabled = false;
        }
        return enabled;
    }

    private boolean isControlPacket(Ethernet eth) {
        short type = eth.getEtherType();
        return type == -30516 || type == -30398;
    }

    private boolean isIpv6Multicast(Ethernet eth) {
        return eth.getEtherType() == -31011 && eth.isMulticast();
    }

    private Path pickForwardPath(Set<Path> paths, PortNumber notToPort) {
        for (Path path : paths) {
            if (path.src().port().equals((Object)notToPort)) continue;
            return path;
        }
        return null;
    }

    private void flood(PacketContext context) {
        if (this.topologyService.isBroadcastPoint(this.topologyService.currentTopology(), context.inPacket().receivedFrom())) {
            this.packetOut(context, PortNumber.FLOOD);
        } else {
            context.block();
        }
    }

    private void packetOut(PacketContext context, PortNumber portNumber) {
        context.treatmentBuilder().setOutput(portNumber);
        context.send();
    }

    private void installRule(PacketContext context, PortNumber portNumber) {
        Ethernet inPkt = context.inPacket().parsed();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder();
        if (this.packetOutOnly || inPkt.getEtherType() == 2054) {
            this.packetOut(context, portNumber);
            return;
        }
        if (this.matchDstMacOnly) {
            builder.matchEthDst(inPkt.getDestinationMAC());
        } else {
            builder.matchInPort(context.inPacket().receivedFrom().port()).matchEthSrc(inPkt.getSourceMAC()).matchEthDst(inPkt.getDestinationMAC()).matchEthType(inPkt.getEtherType());
            if (this.matchVlanId && inPkt.getVlanID() != -1) {
                builder.matchVlanId(VlanId.vlanId((short)inPkt.getVlanID()));
            }
            if (this.matchIpv4Address && inPkt.getEtherType() == 2048) {
                IPv4 ipv4Packet = (IPv4)inPkt.getPayload();
                byte ipv4Protocol = ipv4Packet.getProtocol();
                Ip4Prefix matchIp4SrcPrefix = Ip4Prefix.valueOf((int)ipv4Packet.getSourceAddress(), (int)32);
                Ip4Prefix matchIp4DstPrefix = Ip4Prefix.valueOf((int)ipv4Packet.getDestinationAddress(), (int)32);
                builder.matchIPSrc((IpPrefix)matchIp4SrcPrefix).matchIPDst((IpPrefix)matchIp4DstPrefix).matchIPProtocol(ipv4Protocol);
                if (this.matchIpv4Dscp) {
                    byte dscp = ipv4Packet.getDscp();
                    byte ecn = ipv4Packet.getEcn();
                    builder.matchIPDscp(dscp).matchIPEcn(ecn);
                }
                if (this.matchTcpUdpPorts && ipv4Protocol == 6) {
                    TCP tcpPacket = (TCP)ipv4Packet.getPayload();
                    builder.matchTcpSrc(tcpPacket.getSourcePort()).matchTcpDst(tcpPacket.getDestinationPort());
                }
                if (this.matchTcpUdpPorts && ipv4Protocol == 17) {
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    builder.matchUdpSrc(udpPacket.getSourcePort()).matchUdpDst(udpPacket.getDestinationPort());
                }
                if (this.matchIcmpFields && ipv4Protocol == 1) {
                    ICMP icmpPacket = (ICMP)ipv4Packet.getPayload();
                    builder.matchIcmpType(icmpPacket.getIcmpType()).matchIcmpCode(icmpPacket.getIcmpCode());
                }
            }
            if (this.matchIpv6Address && inPkt.getEtherType() == -31011) {
                IPv6 ipv6Packet = (IPv6)inPkt.getPayload();
                byte ipv6NextHeader = ipv6Packet.getNextHeader();
                Ip6Prefix matchIp6SrcPrefix = Ip6Prefix.valueOf((byte[])ipv6Packet.getSourceAddress(), (int)128);
                Ip6Prefix matchIp6DstPrefix = Ip6Prefix.valueOf((byte[])ipv6Packet.getDestinationAddress(), (int)128);
                builder.matchIPv6Src((IpPrefix)matchIp6SrcPrefix).matchIPv6Dst((IpPrefix)matchIp6DstPrefix).matchIPProtocol(ipv6NextHeader);
                if (this.matchIpv6FlowLabel) {
                    builder.matchIPv6FlowLabel(ipv6Packet.getFlowLabel());
                }
                if (this.matchTcpUdpPorts && ipv6NextHeader == 6) {
                    TCP tcpPacket = (TCP)ipv6Packet.getPayload();
                    builder.matchTcpSrc(tcpPacket.getSourcePort()).matchTcpDst(tcpPacket.getDestinationPort());
                }
                if (this.matchTcpUdpPorts && ipv6NextHeader == 17) {
                    UDP udpPacket = (UDP)ipv6Packet.getPayload();
                    builder.matchUdpSrc(udpPacket.getSourcePort()).matchUdpDst(udpPacket.getDestinationPort());
                }
                if (this.matchIcmpFields && ipv6NextHeader == 58) {
                    ICMP6 icmp6Packet = (ICMP6)ipv6Packet.getPayload();
                    builder.matchIcmpv6Type(icmp6Packet.getIcmpType()).matchIcmpv6Code(icmp6Packet.getIcmpCode());
                }
            }
        }
        TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
        treat.setOutput(portNumber);
        DefaultFlowRule f = new DefaultFlowRule(context.inPacket().receivedFrom().deviceId(), builder.build(), treat.build(), this.flowPriority, this.appId, this.flowTimeout, false);
        this.flowRuleService.applyFlowRules(new FlowRule[]{f});
        if (this.packetOutOfppTable) {
            this.packetOut(context, PortNumber.TABLE);
        } else {
            this.packetOut(context, portNumber);
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            if (ReactiveForwarding.this.isControlPacket(ethPkt)) {
                return;
            }
            if (!ReactiveForwarding.this.ipv6Forwarding && ReactiveForwarding.this.isIpv6Multicast(ethPkt)) {
                return;
            }
            HostId id = HostId.hostId((MacAddress)ethPkt.getDestinationMAC());
            if (id.mac().isLinkLocal()) {
                return;
            }
            Host dst = ReactiveForwarding.this.hostService.getHost(id);
            if (dst == null) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            if (pkt.receivedFrom().deviceId().equals((Object)dst.location().deviceId())) {
                if (!context.inPacket().receivedFrom().port().equals((Object)dst.location().port())) {
                    ReactiveForwarding.this.installRule(context, dst.location().port());
                }
                return;
            }
            Set paths = ReactiveForwarding.this.topologyService.getPaths(ReactiveForwarding.this.topologyService.currentTopology(), pkt.receivedFrom().deviceId(), dst.location().deviceId());
            if (paths.isEmpty()) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            Path path = ReactiveForwarding.this.pickForwardPath(paths, pkt.receivedFrom().port());
            if (path == null) {
                ReactiveForwarding.this.log.warn("Doh... don't know where to go... {} -> {} received on {}", new Object[]{ethPkt.getSourceMAC(), ethPkt.getDestinationMAC(), pkt.receivedFrom()});
                ReactiveForwarding.this.flood(context);
                return;
            }
            ReactiveForwarding.this.installRule(context, path.src().port());
        }
    }
}

