/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.influxdbmetrics;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.influxdbmetrics.DefaultInfluxMetric;
import org.onosproject.influxdbmetrics.InfluxDbMetricsRetriever;
import org.onosproject.influxdbmetrics.InfluxMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultInfluxDbMetricsRetriever
implements InfluxDbMetricsRetriever {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_POLICY = "default";
    private static final String COLON_SEPARATOR = ":";
    private static final String SLASH_SEPARATOR = "//";
    private static final String BRACKET_START = "[";
    private static final String BRACKET_END = "]";
    private static final String METRIC_DELIMITER = ".";
    private static final int NUB_OF_DELIMITER = 3;
    private static final BiMap<TimeUnit, String> TIME_UNIT_MAP = EnumHashBiMap.create(TimeUnit.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    protected String database;
    InfluxDB influxDB;

    @Activate
    public void activate() {
        this.coreService.registerApplication("org.onosproject.influxdbmetrics");
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public void config(String address, int port, String database, String username, String password) {
        StringBuilder url = new StringBuilder();
        url.append(DEFAULT_PROTOCOL);
        url.append("://");
        url.append(address);
        url.append(COLON_SEPARATOR);
        url.append(port);
        this.influxDB = InfluxDBFactory.connect((String)url.toString(), (String)username, (String)password);
        this.database = database;
    }

    @Override
    public Map<NodeId, Map<String, List<InfluxMetric>>> allMetrics(int period, TimeUnit unit) {
        Map<NodeId, Set<String>> nameMap = this.allMetricNames();
        HashMap metricsMap = Maps.newHashMap();
        nameMap.forEach((nodeId, metricNames) -> metricsMap.putIfAbsent(nodeId, this.metricsByNodeId((NodeId)nodeId, period, unit)));
        return metricsMap;
    }

    @Override
    public Map<String, List<InfluxMetric>> metricsByNodeId(NodeId nodeId, int period, TimeUnit unit) {
        Map<NodeId, Set<String>> nameMap = this.allMetricNames();
        HashMap map = Maps.newHashMap();
        nameMap.get(nodeId).forEach(metricName -> {
            List<InfluxMetric> value = this.metric(nodeId, (String)metricName, period, unit);
            if (value != null) {
                map.putIfAbsent(metricName, value);
            }
        });
        return map;
    }

    @Override
    public Map<NodeId, List<InfluxMetric>> metricsByName(String metricName, int period, TimeUnit unit) {
        HashMap map = Maps.newHashMap();
        ArrayList metrics = Lists.newArrayList();
        String queryPrefix = "SELECT m1_rate FROM" + this.database + METRIC_DELIMITER + this.quote(DEFAULT_POLICY) + METRIC_DELIMITER;
        String querySuffix = " WHERE time > now() - " + period + this.unitString(unit);
        this.allMetricNames().keySet().forEach(nodeId -> {
            String queryString = queryPrefix + this.quote(nodeId + METRIC_DELIMITER + metricName) + querySuffix;
            Query query = new Query(queryString, this.database);
            List results = this.influxDB.query(query).getResults();
            if (results != null && results.get(0) != null && ((QueryResult.Result)results.get(0)).getSeries() != null) {
                ((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().forEach(value -> metrics.add(new DefaultInfluxMetric.Builder().time((String)value.get(0)).oneMinRate((Double)value.get(1)).build()));
                map.putIfAbsent(nodeId, metrics);
            }
        });
        return map;
    }

    @Override
    public List<InfluxMetric> metric(NodeId nodeId, String metricName, int period, TimeUnit unit) {
        ArrayList metrics = Lists.newArrayList();
        String queryString = "SELECT m1_rate FROM " + this.database + METRIC_DELIMITER + this.quote(DEFAULT_POLICY) + METRIC_DELIMITER + this.quote(nodeId + METRIC_DELIMITER + metricName) + " WHERE time > now() - " + period + this.unitString(unit);
        Query query = new Query(queryString, this.database);
        List results = this.influxDB.query(query).getResults();
        if (results != null && results.get(0) != null && ((QueryResult.Result)results.get(0)).getSeries() != null) {
            ((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().forEach(value -> metrics.add(new DefaultInfluxMetric.Builder().time((String)value.get(0)).oneMinRate((Double)value.get(1)).build()));
            return metrics;
        }
        return null;
    }

    @Override
    public Map<NodeId, Map<String, InfluxMetric>> allMetrics() {
        Map<NodeId, Set<String>> nameMap = this.allMetricNames();
        HashMap metricsMap = Maps.newHashMap();
        nameMap.forEach((nodeId, metricNames) -> metricsMap.putIfAbsent(nodeId, this.metricsByNodeId((NodeId)nodeId)));
        return metricsMap;
    }

    @Override
    public Map<String, InfluxMetric> metricsByNodeId(NodeId nodeId) {
        Map<NodeId, Set<String>> nameMap = this.allMetricNames();
        HashMap map = Maps.newHashMap();
        nameMap.get(nodeId).forEach(metricName -> {
            InfluxMetric value = this.metric(nodeId, (String)metricName);
            if (value != null) {
                map.putIfAbsent(metricName, value);
            }
        });
        return map;
    }

    @Override
    public Map<NodeId, InfluxMetric> metricsByName(String metricName) {
        HashMap map = Maps.newHashMap();
        String queryPrefix = "SELECT m1_rate FROM" + this.database + METRIC_DELIMITER + this.quote(DEFAULT_POLICY) + METRIC_DELIMITER;
        String querySuffix = " LIMIT 1";
        this.allMetricNames().keySet().forEach(nodeId -> {
            String queryString = queryPrefix + this.quote(nodeId + METRIC_DELIMITER + metricName) + querySuffix;
            Query query = new Query(queryString, this.database);
            List results = this.influxDB.query(query).getResults();
            if (results != null && results.get(0) != null && ((QueryResult.Result)results.get(0)).getSeries() != null) {
                InfluxMetric metric = new DefaultInfluxMetric.Builder().time((String)((List)((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().get(0)).get(0)).oneMinRate((Double)((List)((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().get(0)).get(1)).build();
                map.putIfAbsent(nodeId, metric);
            }
        });
        return map;
    }

    @Override
    public InfluxMetric metric(NodeId nodeId, String metricName) {
        String queryString = "SELECT m1_rate FROM " + this.database + METRIC_DELIMITER + this.quote(DEFAULT_POLICY) + METRIC_DELIMITER + this.quote(nodeId + METRIC_DELIMITER + metricName) + " LIMIT 1";
        Query query = new Query(queryString, this.database);
        List results = this.influxDB.query(query).getResults();
        if (results != null && results.get(0) != null && ((QueryResult.Result)results.get(0)).getSeries() != null) {
            return new DefaultInfluxMetric.Builder().time((String)((List)((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().get(0)).get(0)).oneMinRate((Double)((List)((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues().get(0)).get(1)).build();
        }
        return null;
    }

    private String unitString(TimeUnit unit) {
        return TIME_UNIT_MAP.get((Object)unit) == null ? "h" : (String)TIME_UNIT_MAP.get((Object)unit);
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }

    protected Map<NodeId, Set<String>> allMetricNames() {
        HashMap metricNameMap = Maps.newHashMap();
        Query query = new Query("SHOW MEASUREMENTS", this.database);
        List results = this.influxDB.query(query).getResults();
        List rawMetricNames = ((QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0)).getValues();
        rawMetricNames.forEach(rawMetricName -> {
            String nodeIdStr = this.getNodeId(this.strip(rawMetricName.toString()));
            if (nodeIdStr != null) {
                NodeId nodeId = NodeId.nodeId((String)nodeIdStr);
                String metricName = this.getMetricName(this.strip(rawMetricName.toString()));
                if (!metricNameMap.containsKey(nodeId)) {
                    metricNameMap.putIfAbsent(nodeId, Sets.newHashSet());
                }
                if (metricName != null) {
                    ((Set)metricNameMap.get(nodeId)).add(metricName);
                }
            }
        });
        return metricNameMap;
    }

    private String strip(String fullName) {
        return StringUtils.strip((String)StringUtils.strip((String)fullName, (String)BRACKET_START), (String)BRACKET_END);
    }

    private String getMetricName(String fullName) {
        int index = StringUtils.lastOrdinalIndexOf((String)fullName, (String)METRIC_DELIMITER, (int)3);
        if (index != -1) {
            return StringUtils.substring((String)fullName, (int)(index + 1));
        }
        this.log.warn("Database {} contains malformed metric name.", (Object)this.database);
        return null;
    }

    private String getNodeId(String fullName) {
        int index = StringUtils.lastOrdinalIndexOf((String)fullName, (String)METRIC_DELIMITER, (int)3);
        if (index != -1) {
            return StringUtils.substring((String)fullName, (int)0, (int)index);
        }
        this.log.warn("Database {} contains malformed node id.", (Object)this.database);
        return null;
    }

    static {
        TIME_UNIT_MAP.put((Object)TimeUnit.DAYS, (Object)"d");
        TIME_UNIT_MAP.put((Object)TimeUnit.HOURS, (Object)"h");
        TIME_UNIT_MAP.put((Object)TimeUnit.MINUTES, (Object)"m");
        TIME_UNIT_MAP.put((Object)TimeUnit.SECONDS, (Object)"s");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

