/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.influxdbmetrics;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.onosproject.influxdbmetrics.InfluxMetric;

public final class DefaultInfluxMetric
implements InfluxMetric {
    private double oneMinRate;
    private DateTime time;

    private DefaultInfluxMetric(double oneMinRate, DateTime time) {
        this.oneMinRate = oneMinRate;
        this.time = time;
    }

    @Override
    public double oneMinRate() {
        return this.oneMinRate;
    }

    @Override
    public DateTime time() {
        return this.time;
    }

    public static final class Builder
    implements InfluxMetric.Builder {
        private double oneMinRate;
        private String timestamp;
        private static final String TIMESTAMP_MSG = "Must specify a timestamp.";
        private static final String ONE_MIN_RATE_MSG = "Must specify one minute rate.";

        @Override
        public InfluxMetric.Builder oneMinRate(double rate) {
            this.oneMinRate = rate;
            return this;
        }

        @Override
        public InfluxMetric.Builder time(String time) {
            this.timestamp = time;
            return this;
        }

        @Override
        public InfluxMetric build() {
            Preconditions.checkNotNull((Object)this.oneMinRate, (Object)ONE_MIN_RATE_MSG);
            Preconditions.checkNotNull((Object)this.timestamp, (Object)TIMESTAMP_MSG);
            return new DefaultInfluxMetric(this.oneMinRate, this.parseTime(this.timestamp));
        }

        private DateTime parseTime(String time) {
            String reformatTime = StringUtils.replace((String)StringUtils.replace((String)time, (String)"T", (String)" "), (String)"Z", (String)"");
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            return formatter.parseDateTime(reformatTime);
        }
    }
}

