/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.topology;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.EventMetric;
import org.onlab.metrics.MetricsService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.metrics.topology.TopologyMetricsService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TopologyMetrics
implements TopologyMetricsService {
    private static final Logger log = LoggerFactory.getLogger(TopologyMetrics.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    private ApplicationId appId;
    private LinkedList<Event> lastEvents = new LinkedList();
    private static final int LAST_EVENTS_MAX_N = 100;
    private final DeviceListener deviceListener = new InnerDeviceListener();
    private final HostListener hostListener = new InnerHostListener();
    private final LinkListener linkListener = new InnerLinkListener();
    private final TopologyListener topologyListener = new InnerTopologyListener();
    private static final String COMPONENT_NAME = "Topology";
    private static final String FEATURE_DEVICE_NAME = "DeviceEvent";
    private static final String FEATURE_HOST_NAME = "HostEvent";
    private static final String FEATURE_LINK_NAME = "LinkEvent";
    private static final String FEATURE_GRAPH_NAME = "GraphEvent";
    private static final String FEATURE_GRAPH_REASONS_NAME = "GraphReasonsEvent";
    private EventMetric topologyDeviceEventMetric;
    private EventMetric topologyHostEventMetric;
    private EventMetric topologyLinkEventMetric;
    private EventMetric topologyGraphEventMetric;
    private EventMetric topologyGraphReasonsEventMetric;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.metrics");
        this.clear();
        this.registerMetrics();
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.topologyService.addListener((EventListener)this.topologyListener);
        log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.topologyService.removeListener((EventListener)this.topologyListener);
        this.removeMetrics();
        this.clear();
        log.info("Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getEvents() {
        LinkedList<Event> linkedList = this.lastEvents;
        synchronized (linkedList) {
            return ImmutableList.copyOf(this.lastEvents);
        }
    }

    @Override
    public EventMetric topologyDeviceEventMetric() {
        return this.topologyDeviceEventMetric;
    }

    @Override
    public EventMetric topologyHostEventMetric() {
        return this.topologyHostEventMetric;
    }

    @Override
    public EventMetric topologyLinkEventMetric() {
        return this.topologyLinkEventMetric;
    }

    @Override
    public EventMetric topologyGraphEventMetric() {
        return this.topologyGraphEventMetric;
    }

    @Override
    public EventMetric topologyGraphReasonsEventMetric() {
        return this.topologyGraphReasonsEventMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordEvent(Event event, EventMetric eventMetric) {
        LinkedList<Event> linkedList = this.lastEvents;
        synchronized (linkedList) {
            eventMetric.eventReceived();
            while (this.lastEvents.size() >= 100) {
                this.lastEvents.remove();
            }
            this.lastEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        LinkedList<Event> linkedList = this.lastEvents;
        synchronized (linkedList) {
            this.lastEvents.clear();
        }
    }

    private void registerMetrics() {
        this.topologyDeviceEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_DEVICE_NAME);
        this.topologyHostEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_HOST_NAME);
        this.topologyLinkEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_LINK_NAME);
        this.topologyGraphEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_GRAPH_NAME);
        this.topologyGraphReasonsEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_GRAPH_REASONS_NAME);
        this.topologyDeviceEventMetric.registerMetrics();
        this.topologyHostEventMetric.registerMetrics();
        this.topologyLinkEventMetric.registerMetrics();
        this.topologyGraphEventMetric.registerMetrics();
        this.topologyGraphReasonsEventMetric.registerMetrics();
    }

    private void removeMetrics() {
        this.topologyDeviceEventMetric.removeMetrics();
        this.topologyHostEventMetric.removeMetrics();
        this.topologyLinkEventMetric.removeMetrics();
        this.topologyGraphEventMetric.removeMetrics();
        this.topologyGraphReasonsEventMetric.removeMetrics();
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    private class InnerTopologyListener
    implements TopologyListener {
        private InnerTopologyListener() {
        }

        public void event(TopologyEvent event) {
            TopologyMetrics.this.recordEvent((Event)event, TopologyMetrics.this.topologyGraphEventMetric);
            log.debug("Topology Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
            for (Event reason : event.reasons()) {
                TopologyMetrics.this.recordEvent((Event)event, TopologyMetrics.this.topologyGraphReasonsEventMetric);
                log.debug("Topology Event Reason: time = {} type = {} event = {}", new Object[]{reason.time(), reason.type(), reason});
            }
        }
    }

    private class InnerLinkListener
    implements LinkListener {
        private InnerLinkListener() {
        }

        public void event(LinkEvent event) {
            TopologyMetrics.this.recordEvent((Event)event, TopologyMetrics.this.topologyLinkEventMetric);
            log.debug("Link Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
        }
    }

    private class InnerHostListener
    implements HostListener {
        private InnerHostListener() {
        }

        public void event(HostEvent event) {
            TopologyMetrics.this.recordEvent((Event)event, TopologyMetrics.this.topologyHostEventMetric);
            log.debug("Host Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.PORT_STATS_UPDATED) {
                log.info("PORT_STATS_UPDATED event ignored from metrics");
            } else {
                TopologyMetrics.this.recordEvent((Event)event, TopologyMetrics.this.topologyDeviceEventMetric);
                log.info("Device Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
            }
        }
    }
}

