/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.intent.cli;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Command;
import org.onlab.metrics.EventMetric;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.metrics.intent.IntentMetricsService;

@Command(scope="onos", name="intents-events-metrics", description="Lists intent events metrics")
public class IntentEventsMetricsCommand
extends AbstractShellCommand {
    private static final String FORMAT_GAUGE = "Intent %s Event Timestamp (ms from epoch)=%d";
    private static final String FORMAT_METER = "Intent %s Events count=%d rate(events/sec) mean=%f m1=%f m5=%f m15=%f";

    protected void execute() {
        IntentMetricsService service = (IntentMetricsService)IntentEventsMetricsCommand.get(IntentMetricsService.class);
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
            ObjectNode result = mapper.createObjectNode();
            result = this.json(mapper, result, "intentSubmitted", service.intentSubmittedEventMetric());
            result = this.json(mapper, result, "intentInstalled", service.intentInstalledEventMetric());
            result = this.json(mapper, result, "intentFailed", service.intentFailedEventMetric());
            result = this.json(mapper, result, "intentWithdrawRequested", service.intentWithdrawRequestedEventMetric());
            result = this.json(mapper, result, "intentWithdrawn", service.intentWithdrawnEventMetric());
            result = this.json(mapper, result, "intentPurged", service.intentPurgedEventMetric());
            this.print("%s", new Object[]{result});
        } else {
            this.printEventMetric("Submitted", service.intentSubmittedEventMetric());
            this.printEventMetric("Installed", service.intentInstalledEventMetric());
            this.printEventMetric("Failed", service.intentFailedEventMetric());
            this.printEventMetric("Withdraw Requested", service.intentWithdrawRequestedEventMetric());
            this.printEventMetric("Withdrawn", service.intentWithdrawnEventMetric());
            this.printEventMetric("Purged", service.intentPurgedEventMetric());
        }
    }

    private ObjectNode json(ObjectMapper mapper, ObjectNode objectNode, String propertyPrefix, EventMetric eventMetric) {
        String gaugeName = propertyPrefix + "Timestamp";
        String meterName = propertyPrefix + "Rate";
        Gauge gauge = eventMetric.lastEventTimestampGauge();
        Meter meter = eventMetric.eventRateMeter();
        objectNode.set(gaugeName, this.json(mapper, gauge));
        objectNode.set(meterName, this.json(mapper, meter));
        return objectNode;
    }

    private JsonNode json(ObjectMapper mapper, Object object) {
        try {
            String objectJson = mapper.writeValueAsString(object);
            JsonNode jsonNode = mapper.readTree(objectJson);
            return jsonNode;
        }
        catch (JsonProcessingException e) {
            this.log.error("Error writing value as JSON string", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Error writing value as JSON string", (Throwable)e);
        }
        return null;
    }

    private void printEventMetric(String operationStr, EventMetric eventMetric) {
        Gauge gauge = eventMetric.lastEventTimestampGauge();
        Meter meter = eventMetric.eventRateMeter();
        TimeUnit rateUnit = TimeUnit.SECONDS;
        double rateFactor = rateUnit.toSeconds(1L);
        this.print(FORMAT_GAUGE, new Object[]{operationStr, gauge.getValue()});
        this.print(FORMAT_METER, new Object[]{operationStr, meter.getCount(), meter.getMeanRate() * rateFactor, meter.getOneMinuteRate() * rateFactor, meter.getFiveMinuteRate() * rateFactor, meter.getFifteenMinuteRate() * rateFactor});
    }
}

