/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.mfwd.impl.McastRouteTable;

@Command(scope="onos", name="mcast-delete", description="Delete a multicast route flow")
public class McastDeleteCommand
extends AbstractShellCommand {
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group", required=true, multiValued=false)
    String gAddr = null;
    @Argument(index=2, name="egressList", description="Egress id/port", required=false, multiValued=true)
    String[] egressList = null;

    protected void execute() {
        boolean deleted = false;
        McastRouteTable mrib = McastRouteTable.getInstance();
        if (this.egressList == null) {
            mrib.removeRoute(this.sAddr, this.gAddr);
            deleted = true;
        } else {
            for (String egress : this.egressList) {
                deleted = mrib.removeEgress(this.sAddr, this.gAddr, egress);
            }
        }
        if (deleted) {
            this.print("Successful delete", new Object[0]);
        } else {
            this.print("Failed to delete", new Object[0]);
        }
    }
}

