/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.mfwd.impl.McastConnectPoint;
import org.onosproject.mfwd.impl.McastRouteBase;
import org.onosproject.mfwd.impl.McastRouteTable;

@Command(scope="onos", name="mcast-join", description="Installs a source, multicast group flow")
public class McastJoinCommand
extends AbstractShellCommand {
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group", required=true, multiValued=false)
    String gAddr = null;
    @Argument(index=2, name="ingressPort", description="Ingress port and Egress ports", required=false, multiValued=false)
    String ingressPort = null;
    @Argument(index=3, name="ports", description="Ingress port and Egress ports", required=false, multiValued=true)
    String[] ports = null;

    protected void execute() {
        McastRouteTable mrib = McastRouteTable.getInstance();
        McastRouteBase mr = mrib.addRoute(this.sAddr, this.gAddr);
        if (this.ingressPort != null) {
            String inCP = this.ingressPort;
            this.log.debug("Ingress port provided: " + inCP);
            mr.addIngressPoint(inCP);
        }
        for (int i = 0; i < this.ports.length; ++i) {
            String egCP = this.ports[i];
            this.log.debug("Egress port provided: " + egCP);
            mr.addEgressPoint(egCP, McastConnectPoint.JoinSource.STATIC);
        }
        this.print("Added the mcast route", new Object[0]);
    }
}

