/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.codec.CodecContext;
import org.onosproject.mfwd.impl.MRibCodec;
import org.onosproject.mfwd.impl.McastRouteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="mcast-show", description="Displays the source, multicast group flows")
public class McastShowCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MCAST_GROUP = "mcastgroup";

    protected void execute() {
        McastRouteTable mrt = McastRouteTable.getInstance();
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(mrt)});
        } else {
            this.printMrib4(mrt);
        }
    }

    public JsonNode json(McastRouteTable mrt) {
        ObjectNode pushContent = new MRibCodec().encode(mrt, (CodecContext)this);
        return pushContent;
    }

    protected void printMrib4(McastRouteTable mrt) {
        this.print(mrt.printMcastRouteTable(), new Object[0]);
    }
}

