/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mfwd.impl.McastConnectPoint;
import org.onosproject.mfwd.impl.McastRouteBase;
import org.onosproject.mfwd.impl.McastRouteGroup;
import org.onosproject.mfwd.impl.McastRouteSource;
import org.onosproject.mfwd.impl.McastRouteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRibCodec
extends JsonCodec<McastRouteTable> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String SOURCE_ADDRESS = "sourceAddress";
    private static final String GROUP_ADDRESS = "groupAddress";
    private static final String INGRESS_POINT = "ingressPoint";
    private static final String EGRESS_POINT = "egressPoint";
    private static final String MCASTCONNECTPOINT = "McastConnectPoint";
    private static final String ELEMENTID = "elementId";
    private static final String PORTNUMBER = "portNumber";
    private static final String MCAST_GROUP = "mcastGroup";

    public ObjectNode encode(McastRouteTable mcastRouteTable, CodecContext context) {
        Map mrib4;
        Optional<Map> mrib4Opt;
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ObjectNode macastRouteTabNode = nodeFactory.objectNode();
        ArrayNode mcastGroupNode = context.mapper().createArrayNode();
        Optional<McastRouteTable> mcastRouteTabOpt = Optional.ofNullable(mcastRouteTable);
        if (mcastRouteTabOpt.isPresent() && (mrib4Opt = Optional.ofNullable(mrib4 = mcastRouteTabOpt.get().getMrib4())).isPresent()) {
            for (McastRouteGroup mg : mrib4Opt.get().values()) {
                Collection mcastRoute = mg.getSources().values();
                Optional mcastRouteOpt = Optional.ofNullable(mcastRoute);
                if (!mcastRouteOpt.isPresent()) continue;
                for (McastRouteSource mcastRouteSource : mcastRouteOpt.get()) {
                    mcastGroupNode.add((JsonNode)this.createMcastGroupNode(mcastRouteSource, context));
                }
                macastRouteTabNode.put(MCAST_GROUP, (JsonNode)mcastGroupNode);
            }
        }
        return macastRouteTabNode;
    }

    private ObjectNode createMcastGroupNode(McastRouteSource mcastRouteSource, CodecContext context) {
        ObjectNode mcastGroupNode = context.mapper().createObjectNode();
        ObjectNode ingressNode = context.mapper().createObjectNode();
        ObjectNode egressNode = context.mapper().createObjectNode();
        ArrayNode jsonLabelIds = context.mapper().createArrayNode();
        String sAddr = mcastRouteSource.getSaddr().toString();
        String gAddr = mcastRouteSource.getGaddr().toString();
        Optional<String> saddrOpt = Optional.ofNullable(sAddr);
        Optional<String> gaddrOpt = Optional.ofNullable(gAddr);
        if (saddrOpt.isPresent() && gaddrOpt.isPresent()) {
            mcastGroupNode.put(SOURCE_ADDRESS, saddrOpt.get().toString());
            mcastGroupNode.put(GROUP_ADDRESS, gaddrOpt.get().toString());
            McastConnectPoint mcastIngCP = mcastRouteSource.getIngressPoint();
            Optional<McastConnectPoint> mcastIngCPOpt = Optional.ofNullable(mcastIngCP);
            if (mcastIngCPOpt.isPresent()) {
                ingressNode.put(MCASTCONNECTPOINT, (JsonNode)this.mcastConnectPoint(mcastIngCPOpt.get(), context));
            }
            mcastGroupNode.put(INGRESS_POINT, (JsonNode)ingressNode);
            Set mcastEgCPSet = mcastRouteSource.getEgressPoints();
            Optional<Set> mcastEgCPOpt = Optional.ofNullable(mcastEgCPSet);
            if (mcastEgCPOpt.isPresent()) {
                for (McastConnectPoint mcastConnectPoint : mcastEgCPOpt.get()) {
                    jsonLabelIds.add((JsonNode)this.mcastConnectPoint(mcastConnectPoint, context));
                }
            }
            egressNode.put(MCASTCONNECTPOINT, (JsonNode)jsonLabelIds);
            mcastGroupNode.put(EGRESS_POINT, (JsonNode)egressNode);
        }
        return mcastGroupNode;
    }

    private ObjectNode mcastConnectPoint(McastConnectPoint mcastConnectPoint, CodecContext context) {
        ObjectNode mcastCpNode = context.mapper().createObjectNode();
        mcastCpNode.put(ELEMENTID, mcastConnectPoint.getConnectPoint().elementId().toString());
        mcastCpNode.put(PORTNUMBER, mcastConnectPoint.getConnectPoint().port().toLong());
        return mcastCpNode;
    }

    public McastRouteTable decode(ObjectNode json, CodecContext context) {
        JsonNode egMcastCP;
        Optional<JsonNode> egMcCpOpt;
        Optional<JsonNode> egPntOpt;
        JsonNode inMcastCP;
        Optional<JsonNode> inCpOpt;
        String macAddr = null;
        String portNo = null;
        String sAddr = json.path(SOURCE_ADDRESS).asText();
        String gAddr = json.path(GROUP_ADDRESS).asText();
        JsonNode inPntObjNode = json.path(INGRESS_POINT);
        JsonNode egPntArrNode = json.path(EGRESS_POINT);
        this.log.debug("sAddr :" + sAddr + " gAddr :" + gAddr + " inPntObjNode :" + inPntObjNode);
        this.log.debug("egPntArrNode :" + egPntArrNode.toString());
        McastRouteTable mrib = McastRouteTable.getInstance();
        McastRouteBase mr = mrib.addRoute(sAddr, gAddr);
        Optional<JsonNode> inPntOpt = Optional.ofNullable(inPntObjNode);
        if (inPntOpt.isPresent() && (inCpOpt = Optional.ofNullable(inMcastCP = inPntOpt.get().path(MCASTCONNECTPOINT))).isPresent()) {
            macAddr = inCpOpt.get().path(ELEMENTID).asText();
            portNo = inCpOpt.get().path(PORTNUMBER).asText();
            mr.addIngressPoint(macAddr + "/" + Long.parseLong(portNo));
        }
        if ((egPntOpt = Optional.ofNullable(egPntArrNode)).isPresent() && (egMcCpOpt = Optional.ofNullable(egMcastCP = egPntOpt.get().path(MCASTCONNECTPOINT))).isPresent()) {
            Iterator egCpIt = egMcCpOpt.get().elements();
            while (egCpIt.hasNext()) {
                JsonNode egMcastCPObj = (JsonNode)egCpIt.next();
                Optional<JsonNode> egMcCpObOpt = Optional.ofNullable(egMcastCPObj);
                if (!egMcCpObOpt.isPresent()) continue;
                macAddr = egMcCpObOpt.get().path(ELEMENTID).asText();
                portNo = egMcCpObOpt.get().path(PORTNUMBER).asText();
                this.log.debug("macAddr egPort : " + macAddr + " portNo egPort :" + portNo);
                mr.addEgressPoint(macAddr + "/" + Long.parseLong(portNo), McastConnectPoint.JoinSource.STATIC);
            }
        }
        return mrib;
    }
}

