/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.mfwd.impl.McastForwarding;
import org.onosproject.mfwd.impl.McastRoute;
import org.onosproject.mfwd.impl.McastRouteTable;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class McastForwarding {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IpPrefix mcast = IpPrefix.valueOf((String)"224.0.0.0/4");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor(this, null);
    private McastRouteTable mrib;
    private static ApplicationId appId;

    @Activate
    public void activate() {
        appId = this.coreService.registerApplication("org.onosproject.mfwd");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(this.mcast);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, appId);
        this.mrib = McastRouteTable.getInstance();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("Stopped");
    }

    public static ApplicationId getAppId() {
        return appId;
    }

    private void forwardPacketToDst(PacketContext context, McastRoute entry) {
        for (ConnectPoint egress : entry.getEgressConnectPoints()) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(egress.port()).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(egress.deviceId(), treatment, context.inPacket().unparsed());
            this.packetService.emit((OutboundPacket)packet);
        }
    }

    static /* synthetic */ Logger access$100(McastForwarding x0) {
        return x0.log;
    }

    static /* synthetic */ IpPrefix access$200(McastForwarding x0) {
        return x0.mcast;
    }

    static /* synthetic */ McastRouteTable access$300(McastForwarding x0) {
        return x0.mrib;
    }

    static /* synthetic */ void access$400(McastForwarding x0, PacketContext x1, McastRoute x2) {
        x0.forwardPacketToDst(x1, x2);
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

