/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onosproject.mfwd.impl.McastForwarding;
import org.onosproject.mfwd.impl.McastRoute;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Component(immediate=true)
@Service(value={McastIntentManager.class})
public class McastIntentManager {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    private static McastIntentManager instance;

    public McastIntentManager() {
        instance = this;
    }

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
        this.withdrawAllIntents();
    }

    public static McastIntentManager getInstance() {
        if (instance == null) {
            instance = new McastIntentManager();
        }
        return instance;
    }

    public SinglePointToMultiPointIntent setIntent(McastRoute mroute) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        if (mroute.getIngressPoint() == null) {
            return null;
        }
        selector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(mroute.getGaddr()).matchIPSrc(mroute.getSaddr());
        SinglePointToMultiPointIntent.Builder builder = SinglePointToMultiPointIntent.builder().appId(McastForwarding.getAppId()).selector(selector.build()).treatment(treatment).ingressPoint(mroute.getIngressPoint().getConnectPoint());
        if (!mroute.getEgressPoints().isEmpty()) {
            builder.egressPoints(mroute.getEgressConnectPoints());
        }
        SinglePointToMultiPointIntent intent = builder.build();
        this.intentService.submit((Intent)intent);
        mroute.setDirty(false);
        return intent;
    }

    public void withdrawIntent(McastRoute mroute) {
        Intent intent = this.intentService.getIntent(mroute.getIntentKey());
        this.intentService.withdraw(intent);
        mroute.setDirty(false);
    }

    public void withdrawAllIntents() {
        for (Intent intent : this.intentService.getIntents()) {
            this.intentService.withdraw(intent);
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }
}

