/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onosproject.mfwd.impl.McastConnectPoint;
import org.onosproject.mfwd.impl.McastIntentManager;
import org.onosproject.mfwd.impl.McastRoute;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

public class McastRouteBase
implements McastRoute {
    protected final IpPrefix gaddr;
    protected final IpPrefix saddr;
    protected McastConnectPoint ingressPoint;
    protected Set<McastConnectPoint> egressPoints;
    protected boolean isGroup = false;
    protected boolean dirty = false;
    private int puntCount = 0;
    protected Key intentKey = null;

    public McastRouteBase(String saddr, String gaddr) {
        this.gaddr = IpPrefix.valueOf((String)((String)Preconditions.checkNotNull((Object)gaddr)));
        this.saddr = saddr == null || saddr.equals("*") ? IpPrefix.valueOf((int)0, (int)0) : IpPrefix.valueOf((String)((String)Preconditions.checkNotNull((Object)gaddr)));
        this.init();
    }

    public McastRouteBase(String gaddr) {
        this("*", gaddr);
    }

    public McastRouteBase(IpPrefix gpfx) {
        this(IpPrefix.valueOf((int)0, (int)0), gpfx);
    }

    public McastRouteBase(IpPrefix saddr, IpPrefix gaddr) {
        this.saddr = (IpPrefix)Preconditions.checkNotNull((Object)saddr);
        this.gaddr = (IpPrefix)Preconditions.checkNotNull((Object)gaddr);
        this.init();
    }

    private void init() {
        this.isGroup = this.saddr.prefixLength() == 0;
        this.ingressPoint = null;
        this.egressPoints = new HashSet();
    }

    public IpPrefix getGaddr() {
        return this.gaddr;
    }

    public IpPrefix getSaddr() {
        return this.saddr;
    }

    public boolean isIp4() {
        return this.gaddr.isIp4();
    }

    public boolean isIp6() {
        return this.gaddr.isIp6();
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public boolean isSource() {
        return !this.isGroup;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean addIngressPoint(ConnectPoint ingress) {
        if (this.ingressPoint != null) {
            return false;
        }
        this.ingressPoint = new McastConnectPoint((ConnectPoint)Preconditions.checkNotNull((Object)ingress));
        this.setDirty(true);
        return true;
    }

    public boolean addIngressPoint(String connectPoint) {
        if (this.ingressPoint != null) {
            return false;
        }
        ConnectPoint cp = ConnectPoint.deviceConnectPoint((String)((String)Preconditions.checkNotNull((Object)connectPoint)));
        return this.addIngressPoint(cp);
    }

    public McastConnectPoint getIngressPoint() {
        return this.ingressPoint;
    }

    public McastConnectPoint addEgressPoint(ConnectPoint cp) {
        McastConnectPoint mcp = this.findEgressConnectPoint(cp);
        if (mcp == null) {
            mcp = new McastConnectPoint((ConnectPoint)Preconditions.checkNotNull((Object)cp));
            this.egressPoints.add(mcp);
            this.setDirty(true);
        }
        return mcp;
    }

    public McastConnectPoint addEgressPoint(String connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint);
        return this.addEgressPoint(ConnectPoint.deviceConnectPoint((String)connectPoint));
    }

    public McastConnectPoint addEgressPoint(ConnectPoint cp, McastConnectPoint.JoinSource interest) {
        Preconditions.checkNotNull((Object)cp);
        Preconditions.checkNotNull((Object)interest);
        McastConnectPoint mcp = this.addEgressPoint(cp);
        if (mcp != null) {
            mcp.interest.add(interest);
            this.setDirty(true);
        }
        return mcp;
    }

    public boolean removeEgressPoint(String connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint);
        return this.removeEgressPoint(ConnectPoint.deviceConnectPoint((String)connectPoint));
    }

    public boolean removeEgressPoint(ConnectPoint cp) {
        boolean removed = false;
        McastConnectPoint mcp = this.findEgressConnectPoint((ConnectPoint)Preconditions.checkNotNull((Object)cp));
        if (mcp != null) {
            removed = this.egressPoints.remove(mcp);
            this.setDirty(true);
        }
        return removed;
    }

    public McastConnectPoint addEgressPoint(String cpstr, McastConnectPoint.JoinSource interest) {
        Preconditions.checkNotNull((Object)cpstr);
        Preconditions.checkNotNull((Object)interest);
        return this.addEgressPoint(ConnectPoint.deviceConnectPoint((String)cpstr), interest);
    }

    public Set<McastConnectPoint> getEgressPoints() {
        return this.egressPoints;
    }

    public Set<ConnectPoint> getEgressConnectPoints() {
        HashSet<ConnectPoint> cps = new HashSet<ConnectPoint>();
        for (McastConnectPoint mcp : this.egressPoints) {
            cps.add(mcp.getConnectPoint());
        }
        return cps;
    }

    public McastConnectPoint findEgressConnectPoint(ConnectPoint cp) {
        for (McastConnectPoint mcp : this.egressPoints) {
            if (!mcp.getConnectPoint().equals((Object)cp)) continue;
            return mcp;
        }
        return null;
    }

    public boolean removeInterest(McastConnectPoint mcp, McastConnectPoint.JoinSource interest) {
        Preconditions.checkNotNull((Object)mcp);
        if (mcp.interest.contains(interest)) {
            mcp.interest.remove(interest);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public int getPuntCount() {
        return this.puntCount;
    }

    public void incrementPuntCount() {
        ++this.puntCount;
    }

    public void setIntent() {
        if (this.intentKey != null) {
            this.withdrawIntent();
        }
        McastIntentManager im = McastIntentManager.getInstance();
        SinglePointToMultiPointIntent intent = im.setIntent((McastRoute)this);
        this.intentKey = intent.key();
    }

    public void setIntent(SinglePointToMultiPointIntent intent) {
        this.intentKey = intent.key();
    }

    public Key getIntentKey() {
        return this.intentKey;
    }

    public void withdrawIntent() {
        if (this.intentKey == null) {
            return;
        }
        McastIntentManager im = McastIntentManager.getInstance();
        im.withdrawIntent((McastRoute)this);
        this.intentKey = null;
    }

    public String toString() {
        String out = String.format("(%s, %s)\n\t", this.saddr.toString(), this.gaddr.toString());
        out = out + "intent: ";
        out = out + (this.intentKey == null ? "not installed" : this.intentKey.toString());
        out = out + "\n\tingress: ";
        out = out + (this.ingressPoint == null ? "NULL" : this.ingressPoint.getConnectPoint().toString());
        out = out + "\n\tegress: {\n";
        if (this.egressPoints != null && !this.egressPoints.isEmpty()) {
            for (McastConnectPoint eg : this.egressPoints) {
                out = out + "\t\t" + eg.getConnectPoint().toString() + "\n";
            }
        }
        out = out + "\t}\n";
        out = out + "\tpunted: " + this.getPuntCount() + "\n";
        return out;
    }
}

