/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.onlab.packet.IpPrefix;
import org.onosproject.mfwd.impl.McastRouteBase;
import org.onosproject.mfwd.impl.McastRouteSource;

public class McastRouteGroup
extends McastRouteBase {
    private HashMap<IpPrefix, McastRouteSource> sources;

    public McastRouteGroup(String gaddr) {
        super((String)Preconditions.checkNotNull((Object)gaddr));
        this.init();
    }

    public McastRouteGroup(IpPrefix gpfx) {
        super((IpPrefix)Preconditions.checkNotNull((Object)gpfx));
        this.init();
    }

    private void init() {
        this.sources = new HashMap();
        this.isGroup = true;
    }

    public McastRouteSource findSource(IpPrefix saddr) {
        return (McastRouteSource)this.sources.get(Preconditions.checkNotNull((Object)saddr));
    }

    public HashMap<IpPrefix, McastRouteSource> getSources() {
        return this.sources;
    }

    public void addSource(McastRouteSource src) {
        Preconditions.checkNotNull((Object)src);
        this.sources.put(src.getSaddr(), src);
    }

    public McastRouteSource removeSource(IpPrefix spfx) {
        McastRouteSource src = (McastRouteSource)this.sources.remove(spfx);
        src.withdrawIntent();
        return src;
    }

    public void removeSources() {
        for (McastRouteSource src : this.sources.values()) {
            src.withdrawIntent();
            this.sources.remove(src.getSaddr());
        }
    }
}

