/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpPrefix;
import org.onosproject.mfwd.impl.McastRoute;
import org.onosproject.mfwd.impl.McastRouteBase;
import org.onosproject.mfwd.impl.McastRouteGroup;
import org.onosproject.mfwd.impl.McastRouteSource;

@Service(value={McastRouteTable.class})
public final class McastRouteTable {
    private final Map<IpPrefix, McastRouteGroup> mrib4 = new ConcurrentHashMap();
    private final Map<IpPrefix, McastRouteGroup> mrib6 = this.ipv6Enabled != false ? new ConcurrentHashMap() : null;
    private static McastRouteTable instance = null;
    private Boolean ipv6Enabled = false;

    private McastRouteTable() {
    }

    public static McastRouteTable getInstance() {
        if (instance == null) {
            instance = new McastRouteTable();
        }
        return instance;
    }

    public Map<IpPrefix, McastRouteGroup> getMrib4() {
        return this.mrib4;
    }

    public Map<IpPrefix, McastRouteGroup> getMrib6() {
        return this.mrib6;
    }

    private void storeGroup(McastRouteGroup group) {
        if (group.isIp4()) {
            this.mrib4.put(group.getGaddr(), group);
        } else if (group.isIp6() && this.ipv6Enabled.booleanValue()) {
            this.mrib6.put(group.getGaddr(), group);
        }
    }

    private void removeGroup(McastRouteGroup group) {
        IpPrefix gpfx = group.getGaddr();
        if (gpfx.isIp4()) {
            this.mrib4.remove(gpfx);
        } else if (gpfx.isIp6() && this.ipv6Enabled.booleanValue()) {
            this.mrib6.remove(gpfx);
        }
    }

    public McastRouteBase addRoute(String saddr, String gaddr) {
        IpPrefix gpfx = IpPrefix.valueOf((String)gaddr);
        IpPrefix spfx = IpPrefix.valueOf((int)0, (int)0);
        if (saddr != null && !saddr.equals("*")) {
            spfx = IpPrefix.valueOf((String)saddr);
        }
        return this.addRoute(spfx, gpfx);
    }

    public McastRouteBase addRoute(IpPrefix spfx, IpPrefix gpfx) {
        McastRouteGroup group = this.findMcastGroup(gpfx);
        if (group == null) {
            group = new McastRouteGroup(gpfx);
            if (gpfx.isIp4()) {
                this.mrib4.put(gpfx, group);
            } else if (gpfx.isIp6() && this.ipv6Enabled.booleanValue()) {
                this.mrib6.put(gpfx, group);
            }
        }
        if (spfx.prefixLength() == 0) {
            return group;
        }
        McastRouteSource source = group.findSource(spfx);
        if (source != null) {
            return source;
        }
        source = new McastRouteSource(spfx, gpfx);
        source.setGroup(group);
        group.addSource(source);
        return source;
    }

    public boolean removeEgress(String saddr, String gaddr, String egress) {
        McastRouteSource src;
        boolean removed;
        IpPrefix gpfx = IpPrefix.valueOf((String)gaddr);
        IpPrefix spfx = IpPrefix.valueOf((int)0, (int)0);
        if (saddr != null && !saddr.equals("*")) {
            spfx = IpPrefix.valueOf((String)saddr);
        }
        if (removed = (src = (McastRouteSource)this.findBestMatch(spfx, gpfx)).removeEgressPoint(egress)) {
            src.setIntent();
        }
        return removed;
    }

    public void removeRoute(String saddr, String gaddr) {
        IpPrefix gpfx = IpPrefix.valueOf((String)gaddr);
        IpPrefix spfx = IpPrefix.valueOf((int)0, (int)0);
        if (saddr != null && !saddr.equals("*")) {
            spfx = IpPrefix.valueOf((String)saddr);
        }
        this.removeRoute(spfx, gpfx);
    }

    public void removeRoute(IpPrefix spfx, IpPrefix gpfx) {
        McastRouteGroup group = this.findMcastGroup(gpfx);
        if (group == null) {
            return;
        }
        if (spfx.prefixLength() > 0) {
            group.removeSource(spfx);
            if (group.getSources().size() == 0 && group.getEgressPoints().size() == 0) {
                this.removeGroup(group);
            }
        } else {
            group.removeSources();
            group.withdrawIntent();
            this.removeGroup(group);
        }
    }

    public McastRouteGroup findMcastGroup(IpPrefix group) {
        McastRouteGroup g = null;
        if (group.isIp4()) {
            g = (McastRouteGroup)this.mrib4.get(group);
        } else if (group.isIp6() && this.ipv6Enabled.booleanValue()) {
            g = (McastRouteGroup)this.mrib6.get(group);
        }
        return g;
    }

    public McastRouteSource findMcastSource(IpPrefix saddr, IpPrefix gaddr) {
        McastRouteGroup grp = this.findMcastGroup((IpPrefix)Preconditions.checkNotNull((Object)gaddr));
        if (grp == null) {
            return null;
        }
        return grp.findSource(saddr);
    }

    public McastRoute findBestMatch(IpPrefix saddr, IpPrefix gaddr) {
        McastRouteGroup grp = this.findMcastGroup((IpPrefix)Preconditions.checkNotNull((Object)gaddr));
        if (grp == null) {
            return null;
        }
        McastRouteSource src = grp.findSource((IpPrefix)Preconditions.checkNotNull((Object)saddr));
        if (src == null) {
            return grp;
        }
        return src;
    }

    public String printMcastRouteTable() {
        String out = this.toString() + "\n";
        for (McastRouteGroup grp : this.mrib4.values()) {
            out = out + grp.toString() + "\n";
            for (McastRouteSource src : grp.getSources().values()) {
                out = out + src.toString() + "\n";
            }
        }
        return out;
    }

    public String toString() {
        String out = "Mcast Route Table: ";
        out = out + this.mrib4.size() + " IPv4 Multicast Groups\n";
        if (this.ipv6Enabled.booleanValue()) {
            out = out + this.mrib6.size() + " IPv6 Multicast Groups\n";
        }
        return out;
    }
}

