/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.mfwd.impl.MRibCodec;
import org.onosproject.mfwd.impl.McastConnectPoint;
import org.onosproject.mfwd.impl.McastRouteBase;
import org.onosproject.mfwd.impl.McastRouteTable;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="mcast")
public class McastResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String SOURCE_ADDRESS = "sourceAddress";
    private static final String GROUP_ADDRESS = "groupAddress";
    private static final String INGRESS_POINT = "ingressPoint";
    private static final String EGRESS_POINT = "egressPoint";
    private static final String MCAST_GROUP = "mcastGroup";

    @Path(value="show")
    @GET
    @Produces(value={"application/json"})
    public Response showAll() throws IOException {
        McastRouteTable mrt = McastRouteTable.getInstance();
        ObjectNode pushContent = new MRibCodec().encode(mrt, (CodecContext)this);
        return McastResource.ok((Object)pushContent.toString()).build();
    }

    @Path(value="/join")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response join(@QueryParam(value="src") String sAddr, @QueryParam(value="grp") String gAddr, @DefaultValue(value="") @QueryParam(value="ports") String ports) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.log.debug("Source IP Address: " + sAddr);
        this.log.debug("Destination IP Address: " + gAddr);
        this.log.debug("Ingress and Egress ports: " + ports);
        String output = "Insertion Faild";
        if (sAddr != null && gAddr != null && ports != null) {
            String[] portArr = ports.split(",");
            this.log.debug("Port Array Length: " + portArr.length);
            McastRouteTable mrt = McastRouteTable.getInstance();
            McastRouteBase mr = mrt.addRoute(sAddr, gAddr);
            this.log.debug("checking inside outer if: " + portArr.length);
            if (mr != null && portArr != null && portArr.length > 0) {
                String inCP = portArr[0];
                this.log.debug("Ingress port provided: " + inCP);
                mr.addIngressPoint(inCP);
                for (int i = 1; i < portArr.length; ++i) {
                    String egCP = portArr[i];
                    this.log.debug("Egress port provided: " + egCP);
                    mr.addEgressPoint(egCP, McastConnectPoint.JoinSource.STATIC);
                }
                mrt.printMcastRouteTable();
                output = "Successfully Inserted";
            }
        } else {
            output = "Please Insert the rest uri correctly";
        }
        return Response.ok((Object)output).build();
    }

    @Path(value="/delete")
    @DELETE
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response removeMcastFlow(@QueryParam(value="src") String src, @QueryParam(value="grp") String grp) {
        String resp = "Failed to delete";
        this.log.info("Source IP Address to delete: " + src);
        this.log.info("Destination IP Address to delete: " + grp);
        McastRouteTable mrt = McastRouteTable.getInstance();
        if (src != null && grp != null) {
            mrt.removeRoute(src, grp);
            resp = "Deleted flow for src " + src + " and grp " + grp;
        }
        return Response.ok((Object)resp).build();
    }
}

