/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mfwd.impl.McastForwarding;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(immediate=true)
public class McastForwarding {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MulticastRouteService mcastRouteManager;
    protected McastIntentManager mcastIntentManager;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor(this, null);
    private static ApplicationId appId;

    @Activate
    public void activate() {
        appId = this.coreService.registerApplication("org.onosproject.mfwd");
        this.mcastIntentManager = new McastIntentManager(this);
        this.mcastRouteManager.addListener((EventListener)this.mcastIntentManager);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(IpPrefix.IPV4_MULTICAST_PREFIX);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, appId);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.mcastRouteManager.removeListener((EventListener)this.mcastIntentManager);
        this.mcastIntentManager.withdrawAllIntents();
        this.processor = null;
        this.log.info("Stopped");
    }

    public static ApplicationId getAppId() {
        return appId;
    }

    private void forwardPacketToDst(PacketContext context, ArrayList<ConnectPoint> egressList) {
        for (ConnectPoint egress : egressList) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(egress.port()).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(egress.deviceId(), treatment, context.inPacket().unparsed());
            this.packetService.emit((OutboundPacket)packet);
        }
    }

    public static McastRoute createStaticRoute(String source, String group) {
        Preconditions.checkNotNull((Object)source, (Object)"Must provide a source");
        Preconditions.checkNotNull((Object)group, (Object)"Must provide a group");
        IpAddress ipSource = IpAddress.valueOf((String)source);
        IpAddress ipGroup = IpAddress.valueOf((String)group);
        return McastForwarding.createStaticcreateRoute((IpAddress)ipSource, (IpAddress)ipGroup);
    }

    public static McastRoute createStaticcreateRoute(IpAddress source, IpAddress group) {
        Preconditions.checkNotNull((Object)source, (Object)"Must provide a source");
        Preconditions.checkNotNull((Object)group, (Object)"Must provide a group");
        McastRoute.Type type = McastRoute.Type.STATIC;
        return new McastRoute(source, group, type);
    }

    static /* synthetic */ Logger access$100(McastForwarding x0) {
        return x0.log;
    }

    static /* synthetic */ void access$200(McastForwarding x0, PacketContext x1, ArrayList x2) {
        x0.forwardPacketToDst(x1, x2);
    }

    static /* synthetic */ ApplicationId access$300() {
        return appId;
    }

    static /* synthetic */ IntentService access$400(McastForwarding x0) {
        return x0.intentService;
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindMcastRouteManager(MulticastRouteService multicastRouteService) {
        this.mcastRouteManager = multicastRouteService;
    }

    protected void unbindMcastRouteManager(MulticastRouteService multicastRouteService) {
        if (this.mcastRouteManager == multicastRouteService) {
            this.mcastRouteManager = null;
        }
    }
}

