/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mlb;

import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class MastershipLoadBalancer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int SCHEDULE_PERIOD = 5;
    private static final String REBALANCE_MASTERSHIP = "rebalance/mastership";
    private NodeId localId;
    private AtomicBoolean isLeader = new AtomicBoolean(false);
    private AtomicReference<Future> nextTask = new AtomicReference();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipAdminService mastershipAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private InnerLeadershipListener leadershipListener = new InnerLeadershipListener();
    private InnerMastershipListener mastershipListener = new InnerMastershipListener();
    private ListeningScheduledExecutorService executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());

    @Activate
    public void activate() {
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.localId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((EventListener)this.leadershipListener);
        this.leadershipService.runForLeadership(REBALANCE_MASTERSHIP);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.leadershipService.withdraw(REBALANCE_MASTERSHIP);
        this.leadershipService.removeListener((EventListener)this.leadershipListener);
        this.cancelBalance();
        this.executorService.shutdown();
        this.log.info("Stopped");
    }

    private synchronized void processLeaderChange(NodeId newLeader) {
        boolean currLeader = newLeader.equals((Object)this.localId);
        if (this.isLeader.getAndSet(currLeader) != currLeader) {
            if (currLeader) {
                this.scheduleBalance();
            } else {
                this.cancelBalance();
            }
        }
    }

    private void scheduleBalance() {
        if (this.isLeader.get() && this.nextTask.get() == null) {
            ListenableScheduledFuture task = this.executorService.schedule(() -> ((MastershipAdminService)this.mastershipAdminService).balanceRoles(), 5L, TimeUnit.SECONDS);
            task.addListener(() -> {
                this.log.info("Completed balance roles");
                this.nextTask.set(null);
            }, MoreExecutors.directExecutor());
            if (!this.nextTask.compareAndSet(null, (Future)task)) {
                task.cancel(false);
            }
        }
    }

    private void cancelBalance() {
        Future task = this.nextTask.getAndSet(null);
        if (task != null) {
            task.cancel(false);
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        this.mastershipAdminService = mastershipAdminService;
    }

    protected void unbindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        if (this.mastershipAdminService == mastershipAdminService) {
            this.mastershipAdminService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InnerLeadershipListener
    implements LeadershipEventListener {
        private InnerLeadershipListener() {
        }

        public boolean isRelevant(LeadershipEvent event) {
            return MastershipLoadBalancer.REBALANCE_MASTERSHIP.equals(((Leadership)event.subject()).topic());
        }

        public void event(LeadershipEvent event) {
            MastershipLoadBalancer.this.processLeaderChange(((Leadership)event.subject()).leaderNodeId());
        }
    }

    private class InnerMastershipListener
    implements MastershipListener {
        private InnerMastershipListener() {
        }

        public void event(MastershipEvent event) {
            MastershipLoadBalancer.this.scheduleBalance();
        }
    }
}

