/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mobility;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HostMobility {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ApplicationId appId;
    private ExecutorService eventHandler;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.mobility");
        this.eventHandler = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/app-mobility", (String)"event-handler"));
        this.hostService.addListener((EventListener)new InternalHostListener());
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.eventHandler.shutdown();
        this.log.info("Stopped");
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    public class InternalHostListener
    implements HostListener {
        public void event(HostEvent event) {
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_REMOVED: 
                case HOST_UPDATED: {
                    break;
                }
                case HOST_MOVED: {
                    HostMobility.this.log.info("Host {} has moved; cleaning up.", event.subject());
                    HostMobility.this.eventHandler.execute(() -> this.cleanup((Host)event.subject()));
                    break;
                }
            }
        }

        private void cleanup(Host host) {
            Iterable devices = HostMobility.this.deviceService.getDevices();
            LinkedList flowRules = Lists.newLinkedList();
            for (Device device : devices) {
                flowRules.addAll(this.cleanupDevice(device, host));
            }
            FlowRule[] flows = new FlowRule[flowRules.size()];
            flows = flowRules.toArray(flows);
            HostMobility.this.flowRuleService.removeFlowRules(flows);
        }

        private Collection<? extends FlowRule> cleanupDevice(Device device, Host host) {
            LinkedList flowRules = Lists.newLinkedList();
            MacAddress mac = host.mac();
            for (FlowRule rule : HostMobility.this.flowRuleService.getFlowEntries(device.id())) {
                for (Criterion c : rule.selector().criteria()) {
                    EthCriterion eth;
                    if (c.type() != Criterion.Type.ETH_DST && c.type() != Criterion.Type.ETH_SRC || !(eth = (EthCriterion)c).mac().equals((Object)mac)) continue;
                    flowRules.add(rule);
                }
            }
            return flowRules;
        }
    }
}

