/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.newoptical.PacketLinkRealizedByOptical;
import org.onosproject.newoptical.api.OpticalConnectivityId;

@Beta
public class OpticalConnectivity {
    private final OpticalConnectivityId id;
    private final List<Link> links;
    private final Bandwidth requestBandwidth;
    private final Duration requestLatency;
    private Bandwidth opticalCapacity;
    private final Set<PacketLinkRealizedByOptical> realizingLinks = new HashSet<PacketLinkRealizedByOptical>();
    private State state = State.CREATED;

    public OpticalConnectivity(OpticalConnectivityId id, Path path, Bandwidth requestBandwidth, Duration requestLatency) {
        this.id = id;
        this.links = ImmutableList.copyOf((Collection)path.links());
        this.requestBandwidth = requestBandwidth;
        this.requestLatency = requestLatency;
    }

    public void setLinkEstablished(ConnectPoint src, ConnectPoint dst) {
        this.realizingLinks.stream().filter(l -> l.isBetween(src, dst)).findAny().ifPresent(l -> l.setEstablished(true));
    }

    public void setLinkRemoved(ConnectPoint src, ConnectPoint dst) {
        this.realizingLinks.stream().filter(l -> l.isBetween(src, dst)).findAny().ifPresent(l -> l.setEstablished(false));
    }

    public boolean isAllRealizingLinkEstablished() {
        return this.realizingLinks.stream().allMatch(PacketLinkRealizedByOptical::isEstablished);
    }

    public boolean isAllRealizingLinkNotEstablished() {
        return !this.realizingLinks.stream().anyMatch(PacketLinkRealizedByOptical::isEstablished);
    }

    public OpticalConnectivityId id() {
        return this.id;
    }

    public List<Link> links() {
        return this.links;
    }

    public Bandwidth bandwidth() {
        return this.requestBandwidth;
    }

    public Duration latency() {
        return this.requestLatency;
    }

    public State state() {
        return this.state;
    }

    public boolean state(State state) {
        boolean valid = true;
        switch (this.state) {
            case CREATED: {
                valid = state == State.INSTALLING || state == State.FAILED;
                break;
            }
            case INSTALLING: {
                valid = state == State.INSTALLED || state == State.FAILED;
                break;
            }
            case INSTALLED: {
                valid = state == State.WITHDRAWING || state == State.FAILED;
                break;
            }
            case WITHDRAWING: {
                valid = state == State.WITHDRAWN || state == State.FAILED;
                break;
            }
            case FAILED: {
                valid = state == State.INSTALLING || state == State.WITHDRAWING || state == State.FAILED;
                break;
            }
        }
        if (valid) {
            this.state = state;
        }
        return valid;
    }

    public Bandwidth getOpticalCapacity() {
        return this.opticalCapacity;
    }

    public void setOpticalCapacity(Bandwidth opticalCapacity) {
        this.opticalCapacity = opticalCapacity;
    }

    public void addRealizingLink(PacketLinkRealizedByOptical link) {
        Preconditions.checkNotNull((Object)link);
        this.realizingLinks.add(link);
    }

    public void removeRealizingLink(PacketLinkRealizedByOptical link) {
        Preconditions.checkNotNull((Object)link);
        this.realizingLinks.remove(link);
    }

    public Set<PacketLinkRealizedByOptical> getRealizingLinks() {
        return ImmutableSet.copyOf(this.realizingLinks);
    }

    public static enum State {
        CREATED,
        INSTALLING,
        INSTALLED,
        WITHDRAWING,
        WITHDRAWN,
        FAILED;

    }
}

