/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;

@Beta
public class PacketLinkRealizedByOptical {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Bandwidth bandwidth;
    private final Key realizingIntentKey;
    private boolean established;

    public PacketLinkRealizedByOptical(ConnectPoint src, ConnectPoint dst, Key realizingIntentKey, Bandwidth bandwidth) {
        this.src = src;
        this.dst = dst;
        this.realizingIntentKey = realizingIntentKey;
        this.bandwidth = bandwidth;
        this.established = false;
    }

    public static PacketLinkRealizedByOptical create(ConnectPoint src, ConnectPoint dst, OpticalCircuitIntent intent) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)intent);
        long rate = intent.getSignalType().bitRate();
        return new PacketLinkRealizedByOptical(src, dst, intent.key(), Bandwidth.bps((long)rate));
    }

    public static PacketLinkRealizedByOptical create(ConnectPoint src, ConnectPoint dst, OpticalConnectivityIntent intent) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)intent);
        long rate = intent.getSignalType().bitRate();
        return new PacketLinkRealizedByOptical(src, dst, intent.key(), Bandwidth.bps((long)rate));
    }

    public ConnectPoint src() {
        return this.src;
    }

    public ConnectPoint dst() {
        return this.dst;
    }

    public Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public Key realizingIntentKey() {
        return this.realizingIntentKey;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void setEstablished(boolean established) {
        this.established = established;
    }

    public boolean isBetween(ConnectPoint src, ConnectPoint dst) {
        return this.src.equals((Object)src) && this.dst.equals((Object)dst);
    }
}

