/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.onlab.packet.LLDPTLV;

public class LLDPOrganizationalTLV
extends LLDPTLV {
    public static final int OUI_LENGTH = 3;
    public static final int SUBTYPE_LENGTH = 1;
    public static final byte ORGANIZATIONAL_TLV_TYPE = 127;
    public static final int MAX_INFOSTRING_LENGTH = 507;
    protected byte[] oui;
    protected byte subType;
    private byte[] infoString;

    public LLDPOrganizationalTLV() {
        this.type = (byte)127;
    }

    public LLDPOrganizationalTLV setOUI(byte[] oui) {
        if (oui.length != 3) {
            throw new IllegalArgumentException("The length of OUI must be 3, but it is " + oui.length);
        }
        this.oui = Arrays.copyOf(oui, oui.length);
        return this;
    }

    public byte[] getOUI() {
        return Arrays.copyOf(this.oui, this.oui.length);
    }

    public LLDPOrganizationalTLV setSubType(byte subType) {
        this.subType = subType;
        return this;
    }

    public byte getSubType() {
        return this.subType;
    }

    public LLDPOrganizationalTLV setInfoString(byte[] infoString) {
        if (infoString.length > 507) {
            throw new IllegalArgumentException("The length of infoString cannot exceed 507");
        }
        this.infoString = Arrays.copyOf(infoString, infoString.length);
        return this;
    }

    public LLDPOrganizationalTLV setInfoString(String infoString) {
        byte[] infoStringBytes = infoString.getBytes(Charset.forName("UTF-8"));
        return this.setInfoString(infoStringBytes);
    }

    public byte[] getInfoString() {
        return Arrays.copyOf(this.infoString, this.infoString.length);
    }

    @Override
    public byte[] serialize() {
        if (this.type != 127) {
            return super.serialize();
        }
        int valueLength = 4 + this.infoString.length;
        this.value = new byte[valueLength];
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        bb.put(this.oui);
        bb.put(this.subType);
        bb.put(this.infoString);
        return super.serialize();
    }

    @Override
    public LLDPTLV deserialize(ByteBuffer bb) {
        LLDPTLV tlv = super.deserialize(bb);
        if (tlv.getType() != 127) {
            return tlv;
        }
        ByteBuffer optionalField = ByteBuffer.wrap(this.value);
        byte[] oui = new byte[3];
        optionalField.get(oui);
        this.setOUI(oui);
        this.setSubType(optionalField.get());
        byte[] infoString = new byte[this.getLength() - 3 - 1];
        optionalField.get(infoString);
        this.setInfoString(infoString);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 1423;
        int result = 1;
        result = 1423 * result + this.type;
        result = 1423 * result + this.length;
        result = 1423 * result + Arrays.hashCode(this.oui);
        result = 1423 * result + this.subType;
        result = 1423 * result + Arrays.hashCode(this.infoString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LLDPOrganizationalTLV)) {
            return false;
        }
        LLDPOrganizationalTLV other = (LLDPOrganizationalTLV)o;
        if (this.type != other.type) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!Arrays.equals(this.oui, other.oui)) {
            return false;
        }
        if (this.subType != other.subType) {
            return false;
        }
        return Arrays.equals(this.infoString, other.infoString);
    }
}

