/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tools {
    private static final Logger TOOLS_LOG = LoggerFactory.getLogger(Tools.class);

    private Tools() {
    }

    public static ThreadFactory namedThreads(String pattern) {
        return new ThreadFactoryBuilder().setNameFormat(pattern).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                TOOLS_LOG.error("Uncaught exception on {}", (Object)t.getName(), (Object)e);
            }
        }).build();
    }

    public static ThreadFactory minPriority(ThreadFactory factory) {
        return new ThreadFactoryBuilder().setThreadFactory(factory).setPriority(1).build();
    }

    public static long fromHex(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 16);
    }

    public static String toHex(long value) {
        return Strings.padStart(UnsignedLongs.toString(value, 16), 16, '0');
    }

    public static String toHex(long value, int width) {
        return Strings.padStart(UnsignedLongs.toString(value, 16), width, '0');
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public static List<String> slurp(File path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            return null;
        }
    }
}

