/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.onosproject.event.Event;
import org.onosproject.event.EventAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventAccumulator
implements EventAccumulator {
    private Logger log = LoggerFactory.getLogger(AbstractEventAccumulator.class);
    private final Timer timer;
    private final int maxEvents;
    private final int maxBatchMillis;
    private final int maxIdleMillis;
    private TimerTask idleTask = new ProcessorTask();
    private TimerTask maxTask = new ProcessorTask();
    private List<Event> events = Lists.newArrayList();

    protected AbstractEventAccumulator(Timer timer, int maxEvents, int maxBatchMillis, int maxIdleMillis) {
        this.timer = Preconditions.checkNotNull(timer, "Timer cannot be null");
        Preconditions.checkArgument(maxEvents > 1, "Maximum number of events must be > 1");
        Preconditions.checkArgument(maxBatchMillis > 0, "Maximum millis must be positive");
        Preconditions.checkArgument(maxIdleMillis > 0, "Maximum idle millis must be positive");
        this.maxEvents = maxEvents;
        this.maxBatchMillis = maxBatchMillis;
        this.maxIdleMillis = maxIdleMillis;
    }

    @Override
    public void add(Event event) {
        this.idleTask = this.cancelIfActive(this.idleTask);
        this.events.add(event);
        if (this.events.size() == this.maxEvents) {
            this.maxTask = this.cancelIfActive(this.maxTask);
            this.schedule(1);
        } else {
            this.idleTask = this.schedule(this.maxIdleMillis);
            if (this.events.size() == 1) {
                this.maxTask = this.schedule(this.maxBatchMillis);
            }
        }
    }

    private TimerTask schedule(int millis) {
        ProcessorTask task = new ProcessorTask();
        this.timer.schedule((TimerTask)task, millis);
        return task;
    }

    private TimerTask cancelIfActive(TimerTask task) {
        if (task != null) {
            task.cancel();
        }
        return task;
    }

    private synchronized List<Event> finalizeCurrentBatch() {
        List<Event> toBeProcessed = this.events;
        this.events = Lists.newArrayList();
        return toBeProcessed;
    }

    public Timer timer() {
        return this.timer;
    }

    public int maxEvents() {
        return this.maxEvents;
    }

    public int maxBatchMillis() {
        return this.maxBatchMillis;
    }

    public int maxIdleMillis() {
        return this.maxIdleMillis;
    }

    private class ProcessorTask
    extends TimerTask {
        private ProcessorTask() {
        }

        @Override
        public void run() {
            try {
                AbstractEventAccumulator.this.idleTask = AbstractEventAccumulator.this.cancelIfActive(AbstractEventAccumulator.this.idleTask);
                AbstractEventAccumulator.this.maxTask = AbstractEventAccumulator.this.cancelIfActive(AbstractEventAccumulator.this.maxTask);
                AbstractEventAccumulator.this.processEvents(AbstractEventAccumulator.this.finalizeCurrentBatch());
            }
            catch (Exception e) {
                AbstractEventAccumulator.this.log.warn("Unable to process batch due to {}", (Object)e.getMessage());
            }
        }
    }
}

