/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.cluster.NodeId;

public final class MastershipTerm {
    private final NodeId master;
    private final int termNumber;

    private MastershipTerm(NodeId master, int term) {
        this.master = master;
        this.termNumber = term;
    }

    public static MastershipTerm of(NodeId master, int term) {
        return new MastershipTerm(master, term);
    }

    public NodeId master() {
        return this.master;
    }

    public int termNumber() {
        return this.termNumber;
    }

    public int hashCode() {
        return Objects.hash(this.master, this.termNumber);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MastershipTerm) {
            MastershipTerm that = (MastershipTerm)other;
            return Objects.equals(this.master, that.master) && Objects.equals(this.termNumber, that.termNumber);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("master", this.master).add("termNumber", this.termNumber).toString();
    }
}

