/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.PortNumber;

public class ConnectPoint {
    private final ElementId elementId;
    private final PortNumber portNumber;

    public ConnectPoint(ElementId elementId, PortNumber portNumber) {
        this.elementId = elementId;
        this.portNumber = portNumber;
    }

    public ElementId elementId() {
        return this.elementId;
    }

    public DeviceId deviceId() {
        if (this.elementId instanceof DeviceId) {
            return (DeviceId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an infrastructure device");
    }

    public HostId hostId() {
        if (this.elementId instanceof HostId) {
            return (HostId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an end-station host");
    }

    public PortNumber port() {
        return this.portNumber;
    }

    public int hashCode() {
        return Objects.hash(this.elementId, this.portNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConnectPoint) {
            ConnectPoint other = (ConnectPoint)obj;
            return Objects.equals(this.elementId, other.elementId) && Objects.equals(this.portNumber, other.portNumber);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("elementId", this.elementId).add("portNumber", this.portNumber).toString();
    }
}

