/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;

public class DefaultPort
extends AbstractAnnotated
implements Port {
    public static final long DEFAULT_SPEED = 1000L;
    private final Element element;
    private final PortNumber number;
    private final boolean isEnabled;
    private final Port.Type type;
    private final long portSpeed;

    public DefaultPort(Element element, PortNumber number, boolean isEnabled, Annotations ... annotations) {
        this(element, number, isEnabled, Port.Type.COPPER, 1000L, annotations);
    }

    public DefaultPort(Element element, PortNumber number, boolean isEnabled, Port.Type type, long portSpeed, Annotations ... annotations) {
        super(annotations);
        this.element = element;
        this.number = number;
        this.isEnabled = isEnabled;
        this.type = type;
        this.portSpeed = portSpeed;
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public PortNumber number() {
        return this.number;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Port.Type type() {
        return this.type;
    }

    @Override
    public long portSpeed() {
        return this.portSpeed;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.isEnabled, this.type, this.portSpeed});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPort) {
            DefaultPort other = (DefaultPort)obj;
            return Objects.equals(this.element.id(), other.element.id()) && Objects.equals(this.number, other.number) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.portSpeed, other.portSpeed);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("element", this.element.id()).add("number", this.number).add("isEnabled", this.isEnabled).add("type", (Object)this.type).add("portSpeed", this.portSpeed).toString();
    }
}

