/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.primitives.UnsignedLongs;
import java.util.Objects;

public final class PortNumber {
    public static final PortNumber P0 = PortNumber.portNumber(0L);
    private static final long MAX_NUMBER = 0xFFFFFFFFL;
    public static final PortNumber IN_PORT = new PortNumber(-8L);
    public static final PortNumber TABLE = new PortNumber(-7L);
    public static final PortNumber NORMAL = new PortNumber(-6L);
    public static final PortNumber FLOOD = new PortNumber(-5L);
    public static final PortNumber ALL = new PortNumber(-4L);
    public static final PortNumber LOCAL = new PortNumber(-2L);
    private final long number;

    private PortNumber(long number) {
        this.number = number;
    }

    public static PortNumber portNumber(long number) {
        return new PortNumber(number);
    }

    public static PortNumber portNumber(String string) {
        return new PortNumber(UnsignedLongs.decode(string));
    }

    public boolean isLogical() {
        return this.number < 0L || this.number > 0xFFFFFFFFL;
    }

    public long toLong() {
        return this.number;
    }

    public String toString() {
        return UnsignedLongs.toString(this.number);
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PortNumber) {
            PortNumber other = (PortNumber)obj;
            return this.number == other.number;
        }
        return false;
    }
}

