/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.net.flow.BatchOperationEntry;

public abstract class BatchOperation<T extends BatchOperationEntry<?, ?>> {
    private final List<T> ops;

    public BatchOperation() {
        this.ops = new LinkedList<T>();
    }

    public BatchOperation(Collection<T> batchOperations) {
        this.ops = new LinkedList<T>(Preconditions.checkNotNull(batchOperations));
    }

    public void clear() {
        this.ops.clear();
    }

    public int size() {
        return this.ops.size();
    }

    public List<T> getOperations() {
        return Collections.unmodifiableList(this.ops);
    }

    public BatchOperation<T> addOperation(T entry) {
        return this.ops.add(entry) ? this : null;
    }

    public boolean addAll(BatchOperation<T> another) {
        return this.ops.addAll(another.getOperations());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BatchOperation other = (BatchOperation)o;
        return this.ops.equals(other.ops);
    }

    public int hashCode() {
        return this.ops.hashCode();
    }

    public String toString() {
        return this.ops.toString();
    }
}

