/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public final class DefaultTrafficSelector
implements TrafficSelector {
    private final Set<Criterion> criteria;

    private DefaultTrafficSelector(Set<Criterion> criteria) {
        this.criteria = ImmutableSet.copyOf(criteria);
    }

    @Override
    public Set<Criterion> criteria() {
        return this.criteria;
    }

    @Override
    public Criterion getCriterion(Criterion.Type type) {
        for (Criterion c : this.criteria) {
            if (c.type() != type) continue;
            return c;
        }
        return null;
    }

    public int hashCode() {
        return this.criteria.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTrafficSelector) {
            DefaultTrafficSelector that = (DefaultTrafficSelector)obj;
            return Objects.equals(this.criteria, that.criteria);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("criteria", this.criteria).toString();
    }

    public static TrafficSelector.Builder builder() {
        return new Builder();
    }

    public static TrafficSelector.Builder builder(TrafficSelector selector) {
        return new Builder(selector);
    }

    public static final class Builder
    implements TrafficSelector.Builder {
        private final Map<Criterion.Type, Criterion> selector = new HashMap<Criterion.Type, Criterion>();

        private Builder() {
        }

        private Builder(TrafficSelector selector) {
            for (Criterion c : selector.criteria()) {
                this.add(c);
            }
        }

        @Override
        public Builder add(Criterion criterion) {
            this.selector.put(criterion.type(), criterion);
            return this;
        }

        @Override
        public Builder matchInport(PortNumber port) {
            return this.add(Criteria.matchInPort(port));
        }

        @Override
        public Builder matchEthSrc(MacAddress addr) {
            return this.add(Criteria.matchEthSrc(addr));
        }

        @Override
        public Builder matchEthDst(MacAddress addr) {
            return this.add(Criteria.matchEthDst(addr));
        }

        @Override
        public Builder matchEthType(short ethType) {
            return this.add(Criteria.matchEthType(ethType));
        }

        @Override
        public Builder matchVlanId(VlanId vlanId) {
            return this.add(Criteria.matchVlanId(vlanId));
        }

        @Override
        public Builder matchVlanPcp(Byte vlanPcp) {
            return this.add(Criteria.matchVlanPcp(vlanPcp));
        }

        @Override
        public Builder matchIPProtocol(Byte proto) {
            return this.add(Criteria.matchIPProtocol(proto));
        }

        @Override
        public Builder matchIPSrc(IpPrefix ip) {
            return this.add(Criteria.matchIPSrc(ip));
        }

        @Override
        public Builder matchIPDst(IpPrefix ip) {
            return this.add(Criteria.matchIPDst(ip));
        }

        @Override
        public Builder matchTcpSrc(Short tcpPort) {
            return this.add(Criteria.matchTcpSrc(tcpPort));
        }

        @Override
        public Builder matchTcpDst(Short tcpPort) {
            return this.add(Criteria.matchTcpDst(tcpPort));
        }

        @Override
        public Builder matchMplsLabel(Integer mplsLabel) {
            return this.add(Criteria.matchMplsLabel(mplsLabel));
        }

        @Override
        public Builder matchLambda(Short lambda) {
            return this.add(Criteria.matchLambda(lambda));
        }

        @Override
        public Builder matchOpticalSignalType(Short signalType) {
            return this.add(Criteria.matchOpticalSignalType(signalType));
        }

        @Override
        public TrafficSelector build() {
            return new DefaultTrafficSelector(ImmutableSet.copyOf(this.selector.values()));
        }
    }
}

