/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;

public final class DefaultTrafficTreatment
implements TrafficTreatment {
    private final List<Instruction> instructions;

    private DefaultTrafficTreatment(List<Instruction> instructions) {
        this.instructions = ImmutableList.copyOf(instructions);
    }

    @Override
    public List<Instruction> instructions() {
        return this.instructions;
    }

    public static TrafficTreatment.Builder builder() {
        return new Builder();
    }

    public static TrafficTreatment.Builder builder(TrafficTreatment treatment) {
        return new Builder(treatment);
    }

    public int hashCode() {
        return Objects.hash(this.instructions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTrafficTreatment) {
            DefaultTrafficTreatment that = (DefaultTrafficTreatment)obj;
            return Objects.equals(this.instructions, that.instructions);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("instructions", this.instructions).toString();
    }

    public static final class Builder
    implements TrafficTreatment.Builder {
        boolean drop = false;
        List<Instruction> outputs = new LinkedList<Instruction>();
        List<Instruction> groups = new LinkedList<Instruction>();
        List<Instruction> modifications = new LinkedList<Instruction>();

        private Builder() {
        }

        private Builder(TrafficTreatment treatment) {
            for (Instruction instruction : treatment.instructions()) {
                this.add(instruction);
            }
        }

        @Override
        public Builder add(Instruction instruction) {
            if (this.drop) {
                return this;
            }
            switch (instruction.type()) {
                case DROP: {
                    this.drop = true;
                    break;
                }
                case OUTPUT: {
                    this.outputs.add(instruction);
                    break;
                }
                case L0MODIFICATION: 
                case L2MODIFICATION: 
                case L3MODIFICATION: {
                    this.modifications.add(instruction);
                    break;
                }
                case GROUP: {
                    this.groups.add(instruction);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown instruction type: " + (Object)((Object)instruction.type()));
                }
            }
            return this;
        }

        @Override
        public void drop() {
            this.add(Instructions.createDrop());
        }

        @Override
        public Builder setOutput(PortNumber number) {
            return this.add(Instructions.createOutput(number));
        }

        @Override
        public Builder setEthSrc(MacAddress addr) {
            return this.add(Instructions.modL2Src(addr));
        }

        @Override
        public Builder setEthDst(MacAddress addr) {
            return this.add(Instructions.modL2Dst(addr));
        }

        @Override
        public Builder setVlanId(VlanId id) {
            return this.add(Instructions.modVlanId(id));
        }

        @Override
        public Builder setVlanPcp(Byte pcp) {
            return this.add(Instructions.modVlanPcp(pcp));
        }

        @Override
        public Builder setIpSrc(IpAddress addr) {
            return this.add(Instructions.modL3Src(addr));
        }

        @Override
        public Builder setIpDst(IpAddress addr) {
            return this.add(Instructions.modL3Dst(addr));
        }

        @Override
        public Builder pushMpls() {
            return this.add(Instructions.pushMpls());
        }

        @Override
        public Builder popMpls() {
            return this.add(Instructions.popMpls());
        }

        @Override
        public Builder setMpls(Integer mplsLabel) {
            return this.add(Instructions.modMplsLabel(mplsLabel));
        }

        @Override
        public Builder setLambda(short lambda) {
            return this.add(Instructions.modL0Lambda(lambda));
        }

        @Override
        public TrafficTreatment build() {
            LinkedList<Instruction> instructions = new LinkedList<Instruction>();
            instructions.addAll(this.modifications);
            instructions.addAll(this.groups);
            if (!this.drop) {
                instructions.addAll(this.outputs);
            }
            return new DefaultTrafficTreatment(instructions);
        }
    }
}

