/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;

public class DefaultHostDescription
extends AbstractDescription
implements HostDescription {
    private final MacAddress mac;
    private final VlanId vlan;
    private final HostLocation location;
    private final Set<IpAddress> ip;

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, SparseAnnotations ... annotations) {
        this(mac, vlan, location, Collections.emptySet(), annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, IpAddress ip, SparseAnnotations ... annotations) {
        this(mac, vlan, location, ImmutableSet.of(ip), annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ip, SparseAnnotations ... annotations) {
        super(annotations);
        this.mac = mac;
        this.vlan = vlan;
        this.location = location;
        this.ip = ImmutableSet.copyOf(ip);
    }

    @Override
    public MacAddress hwAddress() {
        return this.mac;
    }

    @Override
    public VlanId vlan() {
        return this.vlan;
    }

    @Override
    public HostLocation location() {
        return this.location;
    }

    @Override
    public Set<IpAddress> ipAddress() {
        return this.ip;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mac", this.mac).add("vlan", this.vlan).add("location", this.location).add("ipAddress", this.ip).toString();
    }
}

