/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;

public abstract class ConnectivityIntent
extends Intent {
    private final TrafficSelector selector;
    private final TrafficTreatment treatment;
    private final List<Constraint> constraints;

    protected ConnectivityIntent(ApplicationId appId, Collection<NetworkResource> resources, TrafficSelector selector, TrafficTreatment treatment) {
        this(appId, resources, selector, treatment, Collections.emptyList());
    }

    protected ConnectivityIntent(ApplicationId appId, Collection<NetworkResource> resources, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints) {
        super(appId, resources);
        this.selector = Preconditions.checkNotNull(selector);
        this.treatment = Preconditions.checkNotNull(treatment);
        this.constraints = Preconditions.checkNotNull(constraints);
    }

    protected ConnectivityIntent() {
        this.selector = null;
        this.treatment = null;
        this.constraints = Collections.emptyList();
    }

    public TrafficSelector selector() {
        return this.selector;
    }

    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    protected static Collection<NetworkResource> resources(Collection<Link> links) {
        return ImmutableSet.copyOf(links);
    }
}

