/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentOperation;

public final class IntentOperations {
    private final List<IntentOperation> operations;
    private final ApplicationId appId;

    private IntentOperations(List<IntentOperation> operations, ApplicationId appId) {
        Preconditions.checkNotNull(operations);
        Preconditions.checkNotNull(appId);
        this.operations = operations;
        this.appId = appId;
    }

    public List<IntentOperation> operations() {
        return this.operations;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public static Builder builder(ApplicationId applicationId) {
        return new Builder(applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.operations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntentOperations other = (IntentOperations)obj;
        return Objects.equals(this.operations, other.operations);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("operations", this.operations).toString();
    }

    public static final class Builder {
        private final ImmutableList.Builder<IntentOperation> builder = ImmutableList.builder();
        private final ApplicationId appId;

        private Builder(ApplicationId appId) {
            this.appId = appId;
        }

        public Builder addSubmitOperation(Intent intent) {
            Preconditions.checkNotNull(intent, "Intent cannot be null");
            this.builder.add((Object)new IntentOperation(IntentOperation.Type.SUBMIT, intent.id(), intent));
            return this;
        }

        public Builder addReplaceOperation(IntentId oldIntentId, Intent newIntent) {
            Preconditions.checkNotNull(oldIntentId, "Intent ID cannot be null");
            Preconditions.checkNotNull(newIntent, "Intent cannot be null");
            this.builder.add((Object)new IntentOperation(IntentOperation.Type.REPLACE, oldIntentId, newIntent));
            return this;
        }

        public Builder addWithdrawOperation(IntentId intentId) {
            Preconditions.checkNotNull(intentId, "Intent ID cannot be null");
            this.builder.add((Object)new IntentOperation(IntentOperation.Type.WITHDRAW, intentId, null));
            return this;
        }

        public Builder addUpdateOperation(IntentId intentId) {
            Preconditions.checkNotNull(intentId, "Intent ID cannot be null");
            this.builder.add((Object)new IntentOperation(IntentOperation.Type.UPDATE, intentId, null));
            return this;
        }

        public IntentOperations build() {
            return new IntentOperations((List)((Object)this.builder.build()), this.appId);
        }
    }
}

