/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public final class MultiPointToSinglePointIntent
extends ConnectivityIntent {
    private final Set<ConnectPoint> ingressPoints;
    private final ConnectPoint egressPoint;

    public MultiPointToSinglePointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint) {
        this(appId, selector, treatment, ingressPoints, egressPoint, Collections.emptyList());
    }

    public MultiPointToSinglePointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint, List<Constraint> constraints) {
        super(appId, null, selector, treatment, constraints);
        Preconditions.checkNotNull(ingressPoints);
        Preconditions.checkArgument(!ingressPoints.isEmpty(), "Ingress point set cannot be empty");
        Preconditions.checkNotNull(egressPoint);
        Preconditions.checkArgument(!ingressPoints.contains(egressPoint), "Set of ingresses should not contain egress (egress: %s)", egressPoint);
        this.ingressPoints = Sets.newHashSet(ingressPoints);
        this.egressPoint = egressPoint;
    }

    protected MultiPointToSinglePointIntent() {
        this.ingressPoints = null;
        this.egressPoint = null;
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("appId", this.appId()).add("selector", this.selector()).add("treatment", this.treatment()).add("ingress", this.ingressPoints()).add("egress", this.egressPoint()).add("constraints", this.constraints()).toString();
    }
}

