/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.LinkResourceService;

public class LinkTypeConstraint
extends BooleanConstraint {
    private final Set<Link.Type> types;
    private final boolean isInclusive;

    public LinkTypeConstraint(boolean inclusive, Link.Type ... types) {
        Preconditions.checkNotNull(types, "Link types cannot be null");
        Preconditions.checkArgument(types.length > 0, "There must be more than one type");
        this.types = ImmutableSet.copyOf(types);
        this.isInclusive = inclusive;
    }

    private LinkTypeConstraint() {
        this.types = null;
        this.isInclusive = false;
    }

    @Override
    public boolean isValid(Link link, LinkResourceService resourceService) {
        boolean contains = this.types.contains((Object)link.type());
        return this.isInclusive ? contains : !contains;
    }

    public Set<Link.Type> types() {
        return this.types;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    public int hashCode() {
        return Objects.hash(this.types, this.isInclusive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LinkTypeConstraint other = (LinkTypeConstraint)obj;
        return Objects.equals(this.types, other.types) && Objects.equals(this.isInclusive, other.isInclusive);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("inclusive", this.isInclusive).add("types", this.types).toString();
    }
}

