/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;

public abstract class DefaultPacketContext
implements PacketContext {
    private final long time;
    private final InboundPacket inPkt;
    private final OutboundPacket outPkt;
    private final TrafficTreatment.Builder builder;
    private final AtomicBoolean block;

    protected DefaultPacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block) {
        this.time = time;
        this.inPkt = inPkt;
        this.outPkt = outPkt;
        this.block = new AtomicBoolean(block);
        this.builder = DefaultTrafficTreatment.builder();
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public InboundPacket inPacket() {
        return this.inPkt;
    }

    @Override
    public OutboundPacket outPacket() {
        return this.outPkt;
    }

    @Override
    public TrafficTreatment.Builder treatmentBuilder() {
        return this.builder;
    }

    @Override
    public abstract void send();

    @Override
    public boolean block() {
        return this.block.getAndSet(true);
    }

    @Override
    public boolean isHandled() {
        return this.block.get();
    }
}

