/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.provider;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ProviderId {
    public static final ProviderId NONE = new ProviderId("none", "none");
    private final String scheme;
    private final String id;
    private final boolean ancillary;

    private ProviderId() {
        this.scheme = null;
        this.id = null;
        this.ancillary = false;
    }

    public ProviderId(String scheme, String id) {
        this(scheme, id, false);
    }

    public ProviderId(String scheme, String id, boolean ancillary) {
        this.scheme = Preconditions.checkNotNull(scheme, "Scheme cannot be null");
        this.id = Preconditions.checkNotNull(id, "ID cannot be null");
        this.ancillary = ancillary;
    }

    public String scheme() {
        return this.scheme;
    }

    public String id() {
        return this.id;
    }

    public boolean isAncillary() {
        return this.ancillary;
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProviderId) {
            ProviderId other = (ProviderId)obj;
            return Objects.equals(this.scheme, other.scheme) && Objects.equals(this.id, other.id) && this.ancillary == other.ancillary;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("scheme", this.scheme).add("id", this.id).add("ancillary", this.ancillary).toString();
    }
}

