/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import org.onlab.util.ByteArraySizeHashPrinter;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.MessageSubject;

public class ClusterMessage {
    private final NodeId sender;
    private final MessageSubject subject;
    private final byte[] payload;

    public ClusterMessage(NodeId sender, MessageSubject subject, byte[] payload) {
        this.sender = sender;
        this.subject = subject;
        this.payload = payload;
    }

    public NodeId sender() {
        return this.sender;
    }

    public MessageSubject subject() {
        return this.subject;
    }

    public byte[] payload() {
        return this.payload;
    }

    public void respond(byte[] data) throws IOException {
        throw new IllegalStateException("One can only repond to message recived from others.");
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("sender", this.sender).add("subject", this.subject).add("payload", ByteArraySizeHashPrinter.of(this.payload)).toString();
    }
}

