/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.store.service.WriteRequest;

public final class BatchWriteRequest {
    private final List<WriteRequest> writeRequests;

    public static BatchWriteRequest create(List<WriteRequest> writeRequests) {
        return new BatchWriteRequest(writeRequests);
    }

    private BatchWriteRequest(List<WriteRequest> writeRequests) {
        this.writeRequests = ImmutableList.copyOf(writeRequests);
    }

    public List<WriteRequest> getAsList() {
        return this.writeRequests;
    }

    public int batchSize() {
        return this.writeRequests.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("writeRequests", this.writeRequests).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<WriteRequest> writeRequests = Lists.newLinkedList();

        public Builder put(String tableName, String key, byte[] value) {
            this.writeRequests.add(WriteRequest.put(tableName, key, value));
            return this;
        }

        public Builder putIfAbsent(String tableName, String key, byte[] value) {
            this.writeRequests.add(WriteRequest.putIfAbsent(tableName, key, value));
            return this;
        }

        public Builder putIfValueMatches(String tableName, String key, byte[] oldValue, byte[] newValue) {
            this.writeRequests.add(WriteRequest.putIfValueMatches(tableName, key, oldValue, newValue));
            return this;
        }

        public Builder putIfVersionMatches(String tableName, String key, byte[] value, long version) {
            this.writeRequests.add(WriteRequest.putIfVersionMatches(tableName, key, value, version));
            return this;
        }

        public Builder remove(String tableName, String key) {
            this.writeRequests.add(WriteRequest.remove(tableName, key));
            return this;
        }

        public Builder removeIfVersionMatches(String tableName, String key, long version) {
            this.writeRequests.add(WriteRequest.removeIfVersionMatches(tableName, key, version));
            return this;
        }

        public Builder removeIfValueMatches(String tableName, String key, byte[] value) {
            this.writeRequests.add(WriteRequest.removeIfValueMatches(tableName, key, value));
            return this;
        }

        public BatchWriteRequest build() {
            return new BatchWriteRequest(this.writeRequests);
        }
    }
}

