/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.ARP;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP;
import org.onlab.packet.Data;
import org.onlab.packet.ICMP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.LLC;
import org.onlab.packet.LLDP;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;

public class Ethernet
extends BasePacket {
    private static final String HEXES = "0123456789ABCDEF";
    public static final short TYPE_ARP = 2054;
    public static final short TYPE_RARP = -32715;
    public static final short TYPE_IPV4 = 2048;
    public static final short TYPE_IPV6 = -31011;
    public static final short TYPE_LLDP = -30516;
    public static final short TYPE_VLAN = -32512;
    public static final short TYPE_BSN = -30398;
    public static final short VLAN_UNTAGGED = -1;
    public static final short MPLS_UNICAST = -30649;
    public static final short MPLS_MULTICAST = -30648;
    public static final short DATALAYER_ADDRESS_LENGTH = 6;
    public static final Map<Short, Class<? extends IPacket>> ETHER_TYPE_CLASS_MAP = new HashMap<Short, Class<? extends IPacket>>();
    protected MacAddress destinationMACAddress;
    protected MacAddress sourceMACAddress;
    protected byte priorityCode;
    protected short vlanID = (short)-1;
    protected short etherType;
    protected boolean pad = false;

    public byte[] getDestinationMACAddress() {
        return this.destinationMACAddress.toBytes();
    }

    public MacAddress getDestinationMAC() {
        return this.destinationMACAddress;
    }

    public Ethernet setDestinationMACAddress(MacAddress destMac) {
        this.destinationMACAddress = Preconditions.checkNotNull(destMac);
        return this;
    }

    public Ethernet setDestinationMACAddress(byte[] destMac) {
        this.destinationMACAddress = MacAddress.valueOf(destMac);
        return this;
    }

    public Ethernet setDestinationMACAddress(String destMac) {
        this.destinationMACAddress = MacAddress.valueOf(destMac);
        return this;
    }

    public byte[] getSourceMACAddress() {
        return this.sourceMACAddress.toBytes();
    }

    public MacAddress getSourceMAC() {
        return this.sourceMACAddress;
    }

    public Ethernet setSourceMACAddress(MacAddress sourceMac) {
        this.sourceMACAddress = Preconditions.checkNotNull(sourceMac);
        return this;
    }

    public Ethernet setSourceMACAddress(byte[] sourceMac) {
        this.sourceMACAddress = MacAddress.valueOf(sourceMac);
        return this;
    }

    public Ethernet setSourceMACAddress(String sourceMac) {
        this.sourceMACAddress = MacAddress.valueOf(sourceMac);
        return this;
    }

    public byte getPriorityCode() {
        return this.priorityCode;
    }

    public Ethernet setPriorityCode(byte priority) {
        this.priorityCode = priority;
        return this;
    }

    public short getVlanID() {
        return this.vlanID;
    }

    public Ethernet setVlanID(short vlan) {
        this.vlanID = vlan;
        return this;
    }

    public short getEtherType() {
        return this.etherType;
    }

    public Ethernet setEtherType(short ethType) {
        this.etherType = ethType;
        return this;
    }

    public boolean isBroadcast() {
        assert (this.destinationMACAddress.length() == 6);
        return this.destinationMACAddress.isBroadcast();
    }

    public boolean isMulticast() {
        return this.destinationMACAddress.isMulticast();
    }

    public boolean isPad() {
        return this.pad;
    }

    public Ethernet setPad(boolean pd) {
        this.pad = pd;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int length = 14 + (this.vlanID == -1 ? 0 : 4) + (payloadData == null ? 0 : payloadData.length);
        if (this.pad && length < 60) {
            length = 60;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.destinationMACAddress.toBytes());
        bb.put(this.sourceMACAddress.toBytes());
        if (this.vlanID != -1) {
            bb.putShort((short)-32512);
            bb.putShort((short)(this.priorityCode << 13 | this.vlanID & 0xFFF));
        }
        bb.putShort(this.etherType);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.pad) {
            Arrays.fill(data, bb.position(), data.length, (byte)0);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        if (length <= 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        if (this.destinationMACAddress == null) {
            this.destinationMACAddress = MacAddress.valueOf(new byte[6]);
        }
        byte[] dstAddr = new byte[6];
        bb.get(dstAddr);
        this.destinationMACAddress = MacAddress.valueOf(dstAddr);
        if (this.sourceMACAddress == null) {
            this.sourceMACAddress = MacAddress.valueOf(new byte[6]);
        }
        byte[] srcAddr = new byte[6];
        bb.get(srcAddr);
        this.sourceMACAddress = MacAddress.valueOf(srcAddr);
        short ethType = bb.getShort();
        if (ethType == -32512) {
            short tci = bb.getShort();
            this.priorityCode = (byte)(tci >> 13 & 7);
            this.vlanID = (short)(tci & 0xFFF);
            ethType = bb.getShort();
        } else {
            this.vlanID = (short)-1;
        }
        this.etherType = ethType;
        if (ETHER_TYPE_CLASS_MAP.containsKey(this.etherType)) {
            Class<? extends IPacket> clazz = ETHER_TYPE_CLASS_MAP.get(this.etherType);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for Ethernet packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    public static boolean isMACAddress(String macAddress) {
        String[] macBytes = macAddress.split(":");
        if (macBytes.length != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (HEXES.indexOf(macBytes[i].toUpperCase().charAt(0)) != -1 && HEXES.indexOf(macBytes[i].toUpperCase().charAt(1)) != -1) continue;
            return false;
        }
        return true;
    }

    public static byte[] toMACAddress(String macAddress) {
        return MacAddress.valueOf(macAddress).toBytes();
    }

    public static long toLong(byte[] macAddress) {
        return MacAddress.valueOf(macAddress).toLong();
    }

    public static byte[] toByteArray(long macAddress) {
        return MacAddress.valueOf(macAddress).toBytes();
    }

    @Override
    public int hashCode() {
        int prime = 7867;
        int result = super.hashCode();
        result = 7867 * result + this.destinationMACAddress.hashCode();
        result = 7867 * result + this.etherType;
        result = 7867 * result + this.vlanID;
        result = 7867 * result + this.priorityCode;
        result = 7867 * result + (this.pad ? 1231 : 1237);
        result = 7867 * result + this.sourceMACAddress.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ethernet)) {
            return false;
        }
        Ethernet other = (Ethernet)obj;
        if (!this.destinationMACAddress.equals(other.destinationMACAddress)) {
            return false;
        }
        if (this.priorityCode != other.priorityCode) {
            return false;
        }
        if (this.vlanID != other.vlanID) {
            return false;
        }
        if (this.etherType != other.etherType) {
            return false;
        }
        if (this.pad != other.pad) {
            return false;
        }
        return this.sourceMACAddress.equals(other.sourceMACAddress);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        IPacket pkt = this.getPayload();
        if (pkt instanceof ARP) {
            sb.append("arp");
        } else if (pkt instanceof LLDP) {
            sb.append("lldp");
        } else if (pkt instanceof ICMP) {
            sb.append("icmp");
        } else if (pkt instanceof IPv4) {
            sb.append("ip");
        } else if (pkt instanceof DHCP) {
            sb.append("dhcp");
        } else {
            sb.append(this.getEtherType());
        }
        sb.append("\ndl_vlan: ");
        if (this.getVlanID() == -1) {
            sb.append("untagged");
        } else {
            sb.append(this.getVlanID());
        }
        sb.append("\ndl_vlan_pcp: ");
        sb.append(this.getPriorityCode());
        sb.append("\ndl_src: ");
        sb.append(Ethernet.bytesToHex(this.getSourceMACAddress()));
        sb.append("\ndl_dst: ");
        sb.append(Ethernet.bytesToHex(this.getDestinationMACAddress()));
        if (pkt instanceof ARP) {
            ARP p = (ARP)pkt;
            sb.append("\nnw_src: ");
            sb.append(IPv4.fromIPv4Address(IPv4.toIPv4Address(p.getSenderProtocolAddress())));
            sb.append("\nnw_dst: ");
            sb.append(IPv4.fromIPv4Address(IPv4.toIPv4Address(p.getTargetProtocolAddress())));
        } else if (pkt instanceof LLDP) {
            sb.append("lldp packet");
        } else if (pkt instanceof ICMP) {
            ICMP icmp = (ICMP)pkt;
            sb.append("\nicmp_type: ");
            sb.append(icmp.getIcmpType());
            sb.append("\nicmp_code: ");
            sb.append(icmp.getIcmpCode());
        } else if (pkt instanceof IPv4) {
            IPv4 p = (IPv4)pkt;
            sb.append("\nnw_src: ");
            sb.append(IPv4.fromIPv4Address(p.getSourceAddress()));
            sb.append("\nnw_dst: ");
            sb.append(IPv4.fromIPv4Address(p.getDestinationAddress()));
            sb.append("\nnw_tos: ");
            sb.append(p.getDiffServ());
            sb.append("\nnw_proto: ");
            sb.append(p.getProtocol());
            if (pkt instanceof TCP) {
                sb.append("\ntp_src: ");
                sb.append(((TCP)pkt).getSourcePort());
                sb.append("\ntp_dst: ");
                sb.append(((TCP)pkt).getDestinationPort());
            } else if (pkt instanceof UDP) {
                sb.append("\ntp_src: ");
                sb.append(((UDP)pkt).getSourcePort());
                sb.append("\ntp_dst: ");
                sb.append(((UDP)pkt).getDestinationPort());
            }
            if (pkt instanceof ICMP) {
                ICMP icmp = (ICMP)pkt;
                sb.append("\nicmp_type: ");
                sb.append(icmp.getIcmpType());
                sb.append("\nicmp_code: ");
                sb.append(icmp.getIcmpCode());
            }
        } else if (pkt instanceof DHCP) {
            sb.append("\ndhcp packet");
        } else if (pkt instanceof Data) {
            sb.append("\ndata packet");
        } else if (pkt instanceof LLC) {
            sb.append("\nllc packet");
        } else {
            sb.append("\nunknown packet");
        }
        return sb.toString();
    }

    public static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    static {
        ETHER_TYPE_CLASS_MAP.put((short)2054, ARP.class);
        ETHER_TYPE_CLASS_MAP.put((short)-32715, ARP.class);
        ETHER_TYPE_CLASS_MAP.put((short)2048, IPv4.class);
        ETHER_TYPE_CLASS_MAP.put((short)-31011, IPv6.class);
        ETHER_TYPE_CLASS_MAP.put((short)-30516, LLDP.class);
        ETHER_TYPE_CLASS_MAP.put((short)-30398, LLDP.class);
    }
}

