/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public final class Ip6Prefix
extends IpPrefix {
    public static final IpAddress.Version VERSION = IpAddress.Version.INET6;
    public static final int MAX_MASK_LENGTH = 128;

    private Ip6Prefix(Ip6Address address, int prefixLength) {
        super(address, prefixLength);
    }

    @Override
    public Ip6Address address() {
        IpAddress a = super.address();
        return (Ip6Address)a;
    }

    public static Ip6Prefix valueOf(byte[] address, int prefixLength) {
        return new Ip6Prefix(Ip6Address.valueOf(address), prefixLength);
    }

    public static Ip6Prefix valueOf(Ip6Address address, int prefixLength) {
        return new Ip6Prefix(address, prefixLength);
    }

    public static Ip6Prefix valueOf(String address) {
        String[] parts = address.split("/");
        if (parts.length != 2) {
            String msg = "Malformed IPv6 prefix string: " + address + "." + "Address must take form " + "\"xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx/y\"";
            throw new IllegalArgumentException(msg);
        }
        Ip6Address ipAddress = Ip6Address.valueOf(parts[0]);
        int prefixLength = Integer.parseInt(parts[1]);
        return new Ip6Prefix(ipAddress, prefixLength);
    }
}

