/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.ipv6.IExtensionHeader;

public class Fragment
extends BasePacket
implements IExtensionHeader {
    public static final byte HEADER_LENGTH = 8;
    protected byte nextHeader;
    protected short fragmentOffset;
    protected byte moreFragment;
    protected int identification;

    @Override
    public byte getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public Fragment setNextHeader(byte nextHeader) {
        this.nextHeader = nextHeader;
        return this;
    }

    public short getFragmentOffset() {
        return this.fragmentOffset;
    }

    public Fragment setFragmentOffset(short fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
        return this;
    }

    public byte getMoreFragment() {
        return this.moreFragment;
    }

    public Fragment setMoreFragment(byte moreFragment) {
        this.moreFragment = moreFragment;
        return this;
    }

    public int getIdentification() {
        return this.identification;
    }

    public Fragment setIdentification(int identification) {
        this.identification = identification;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[8 + payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.nextHeader);
        bb.put((byte)0);
        bb.putShort((short)((this.fragmentOffset & 0x1FFF) << 3 | this.moreFragment & 1));
        bb.putInt(this.identification);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IExtensionHeader) {
            ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)44);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.nextHeader = bb.get();
        bb.get();
        short sscratch = bb.getShort();
        this.fragmentOffset = (short)(sscratch >> 3 & 0x1FFF);
        this.moreFragment = (byte)(sscratch & 1);
        this.identification = bb.getInt();
        if (IPv6.PROTOCOL_CLASS_MAP.containsKey(this.nextHeader)) {
            Class<? extends IPacket> clazz = IPv6.PROTOCOL_CLASS_MAP.get(this.nextHeader);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for Fragment packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.nextHeader;
        result = 5807 * result + this.fragmentOffset;
        result = 5807 * result + this.moreFragment;
        result = 5807 * result + this.identification;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Fragment)) {
            return false;
        }
        Fragment other = (Fragment)obj;
        if (this.nextHeader != other.nextHeader) {
            return false;
        }
        if (this.fragmentOffset != other.fragmentOffset) {
            return false;
        }
        if (this.moreFragment != other.moreFragment) {
            return false;
        }
        return this.identification == other.identification;
    }
}

